/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesBuilder;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceBuilder;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluent;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SearchOperatorSpecFluent<A extends SearchOperatorSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> nodeSelector;
    private String pullpolicy;
    private String pullsecret;
    private PodResourceBuilder redisgraphResource;
    private ImageOverridesBuilder searchimageoverrides;

    public SearchOperatorSpecFluent() {
    }

    public SearchOperatorSpecFluent(SearchOperatorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SearchOperatorSpec instance) {
        SearchOperatorSpec searchOperatorSpec = instance = instance != null ? instance : new SearchOperatorSpec();
        if (instance != null) {
            this.withNodeSelector(instance.getNodeSelector());
            this.withPullpolicy(instance.getPullpolicy());
            this.withPullsecret(instance.getPullsecret());
            this.withRedisgraphResource(instance.getRedisgraphResource());
            this.withSearchimageoverrides(instance.getSearchimageoverrides());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPullpolicy(instance.getPullpolicy());
            this.withPullsecret(instance.getPullsecret());
            this.withRedisgraphResource(instance.getRedisgraphResource());
            this.withSearchimageoverrides(instance.getSearchimageoverrides());
        }
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public String getPullpolicy() {
        return this.pullpolicy;
    }

    public A withPullpolicy(String pullpolicy) {
        this.pullpolicy = pullpolicy;
        return (A)((Object)this);
    }

    public boolean hasPullpolicy() {
        return this.pullpolicy != null;
    }

    public String getPullsecret() {
        return this.pullsecret;
    }

    public A withPullsecret(String pullsecret) {
        this.pullsecret = pullsecret;
        return (A)((Object)this);
    }

    public boolean hasPullsecret() {
        return this.pullsecret != null;
    }

    public PodResource buildRedisgraphResource() {
        return this.redisgraphResource != null ? this.redisgraphResource.build() : null;
    }

    public A withRedisgraphResource(PodResource redisgraphResource) {
        this._visitables.get((Object)"redisgraphResource").remove((Object)this.redisgraphResource);
        if (redisgraphResource != null) {
            this.redisgraphResource = new PodResourceBuilder(redisgraphResource);
            this._visitables.get((Object)"redisgraphResource").add(this.redisgraphResource);
        } else {
            this.redisgraphResource = null;
            this._visitables.get((Object)"redisgraphResource").remove((Object)this.redisgraphResource);
        }
        return (A)((Object)this);
    }

    public boolean hasRedisgraphResource() {
        return this.redisgraphResource != null;
    }

    public A withNewRedisgraphResource(String limitCpu, String limitMemory, String requestCpu, String requestMemory) {
        return this.withRedisgraphResource(new PodResource(limitCpu, limitMemory, requestCpu, requestMemory));
    }

    public RedisgraphResourceNested<A> withNewRedisgraphResource() {
        return new RedisgraphResourceNested(null);
    }

    public RedisgraphResourceNested<A> withNewRedisgraphResourceLike(PodResource item) {
        return new RedisgraphResourceNested(item);
    }

    public RedisgraphResourceNested<A> editRedisgraphResource() {
        return this.withNewRedisgraphResourceLike(Optional.ofNullable(this.buildRedisgraphResource()).orElse(null));
    }

    public RedisgraphResourceNested<A> editOrNewRedisgraphResource() {
        return this.withNewRedisgraphResourceLike(Optional.ofNullable(this.buildRedisgraphResource()).orElse(new PodResourceBuilder().build()));
    }

    public RedisgraphResourceNested<A> editOrNewRedisgraphResourceLike(PodResource item) {
        return this.withNewRedisgraphResourceLike(Optional.ofNullable(this.buildRedisgraphResource()).orElse(item));
    }

    public ImageOverrides buildSearchimageoverrides() {
        return this.searchimageoverrides != null ? this.searchimageoverrides.build() : null;
    }

    public A withSearchimageoverrides(ImageOverrides searchimageoverrides) {
        this._visitables.get((Object)"searchimageoverrides").remove((Object)this.searchimageoverrides);
        if (searchimageoverrides != null) {
            this.searchimageoverrides = new ImageOverridesBuilder(searchimageoverrides);
            this._visitables.get((Object)"searchimageoverrides").add(this.searchimageoverrides);
        } else {
            this.searchimageoverrides = null;
            this._visitables.get((Object)"searchimageoverrides").remove((Object)this.searchimageoverrides);
        }
        return (A)((Object)this);
    }

    public boolean hasSearchimageoverrides() {
        return this.searchimageoverrides != null;
    }

    public A withNewSearchimageoverrides(String redisgraphTls, String searchAggregator, String searchApi, String searchCollector) {
        return this.withSearchimageoverrides(new ImageOverrides(redisgraphTls, searchAggregator, searchApi, searchCollector));
    }

    public SearchimageoverridesNested<A> withNewSearchimageoverrides() {
        return new SearchimageoverridesNested(null);
    }

    public SearchimageoverridesNested<A> withNewSearchimageoverridesLike(ImageOverrides item) {
        return new SearchimageoverridesNested(item);
    }

    public SearchimageoverridesNested<A> editSearchimageoverrides() {
        return this.withNewSearchimageoverridesLike(Optional.ofNullable(this.buildSearchimageoverrides()).orElse(null));
    }

    public SearchimageoverridesNested<A> editOrNewSearchimageoverrides() {
        return this.withNewSearchimageoverridesLike(Optional.ofNullable(this.buildSearchimageoverrides()).orElse(new ImageOverridesBuilder().build()));
    }

    public SearchimageoverridesNested<A> editOrNewSearchimageoverridesLike(ImageOverrides item) {
        return this.withNewSearchimageoverridesLike(Optional.ofNullable(this.buildSearchimageoverrides()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchOperatorSpecFluent that = (SearchOperatorSpecFluent)((Object)o);
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.pullpolicy, that.pullpolicy)) {
            return false;
        }
        if (!Objects.equals(this.pullsecret, that.pullsecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.redisgraphResource, (Object)that.redisgraphResource)) {
            return false;
        }
        return Objects.equals((Object)this.searchimageoverrides, (Object)that.searchimageoverrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeSelector, this.pullpolicy, this.pullsecret, this.redisgraphResource, this.searchimageoverrides, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.pullpolicy != null) {
            sb.append("pullpolicy:");
            sb.append(this.pullpolicy + ",");
        }
        if (this.pullsecret != null) {
            sb.append("pullsecret:");
            sb.append(this.pullsecret + ",");
        }
        if (this.redisgraphResource != null) {
            sb.append("redisgraphResource:");
            sb.append((Object)((Object)this.redisgraphResource) + ",");
        }
        if (this.searchimageoverrides != null) {
            sb.append("searchimageoverrides:");
            sb.append((Object)this.searchimageoverrides);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SearchimageoverridesNested<N>
    extends ImageOverridesFluent<SearchimageoverridesNested<N>>
    implements Nested<N> {
        ImageOverridesBuilder builder;

        SearchimageoverridesNested(ImageOverrides item) {
            this.builder = new ImageOverridesBuilder(this, item);
        }

        public N and() {
            return (N)SearchOperatorSpecFluent.this.withSearchimageoverrides(this.builder.build());
        }

        public N endSearchimageoverrides() {
            return this.and();
        }
    }

    public class RedisgraphResourceNested<N>
    extends PodResourceFluent<RedisgraphResourceNested<N>>
    implements Nested<N> {
        PodResourceBuilder builder;

        RedisgraphResourceNested(PodResource item) {
            this.builder = new PodResourceBuilder(this, item);
        }

        public N and() {
            return (N)SearchOperatorSpecFluent.this.withRedisgraphResource(this.builder.build());
        }

        public N endRedisgraphResource() {
            return this.and();
        }
    }
}

