/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperator;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorBuilder;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorFluentImpl;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorList;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SearchOperatorListFluentImpl<A extends SearchOperatorListFluent<A>>
extends BaseFluent<A>
implements SearchOperatorListFluent<A> {
    private String apiVersion;
    private ArrayList<SearchOperatorBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public SearchOperatorListFluentImpl() {
    }

    public SearchOperatorListFluentImpl(SearchOperatorList instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, SearchOperator item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, SearchOperator item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(SearchOperator ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (SearchOperator item : items) {
            SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<SearchOperator> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (SearchOperator item : items) {
            SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(SearchOperator ... items) {
        for (SearchOperator item : items) {
            SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<SearchOperator> items) {
        for (SearchOperator item : items) {
            SearchOperatorBuilder builder = new SearchOperatorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<SearchOperatorBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<SearchOperatorBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            SearchOperatorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SearchOperator> getItems() {
        return this.items != null ? SearchOperatorListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<SearchOperator> buildItems() {
        return this.items != null ? SearchOperatorListFluentImpl.build(this.items) : null;
    }

    @Override
    public SearchOperator buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public SearchOperator buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public SearchOperator buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public SearchOperator buildMatchingItem(Predicate<SearchOperatorBuilder> predicate) {
        for (SearchOperatorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<SearchOperatorBuilder> predicate) {
        for (SearchOperatorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<SearchOperator> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (SearchOperator item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(SearchOperator ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (SearchOperator item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> addNewItemLike(SearchOperator item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> setNewItemLike(int index, SearchOperator item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SearchOperatorListFluent.ItemsNested<A> editMatchingItem(Predicate<SearchOperatorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchOperatorListFluentImpl that = (SearchOperatorListFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends SearchOperatorFluentImpl<SearchOperatorListFluent.ItemsNested<N>>
    implements SearchOperatorListFluent.ItemsNested<N>,
    Nested<N> {
        SearchOperatorBuilder builder;
        int index;

        ItemsNestedImpl(int index, SearchOperator item) {
            this.index = index;
            this.builder = new SearchOperatorBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new SearchOperatorBuilder(this);
        }

        @Override
        public N and() {
            return (N)SearchOperatorListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

