package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchOperatorSpecBuilder extends SearchOperatorSpecFluentImpl<SearchOperatorSpecBuilder> implements VisitableBuilder<SearchOperatorSpec,SearchOperatorSpecBuilder>{
  public SearchOperatorSpecBuilder() {
    this(false);
  }
  public SearchOperatorSpecBuilder(Boolean validationEnabled) {
    this(new SearchOperatorSpec(), validationEnabled);
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchOperatorSpec(), validationEnabled);
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpecFluent<?> fluent,SearchOperatorSpec instance) {
    this(fluent, instance, false);
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpecFluent<?> fluent,SearchOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withPullpolicy(instance.getPullpolicy());
      fluent.withPullsecret(instance.getPullsecret());
      fluent.withRedisgraphResource(instance.getRedisgraphResource());
      fluent.withSearchimageoverrides(instance.getSearchimageoverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpec instance) {
    this(instance,false);
  }
  public SearchOperatorSpecBuilder(SearchOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withPullpolicy(instance.getPullpolicy());
      this.withPullsecret(instance.getPullsecret());
      this.withRedisgraphResource(instance.getRedisgraphResource());
      this.withSearchimageoverrides(instance.getSearchimageoverrides());
    }
    this.validationEnabled = validationEnabled; 
  }
  SearchOperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SearchOperatorSpec build() {
    SearchOperatorSpec buildable = new SearchOperatorSpec(fluent.getNodeSelector(),fluent.getPullpolicy(),fluent.getPullsecret(),fluent.getRedisgraphResource(),fluent.getSearchimageoverrides());
    return buildable;
  }
  
}