package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchOperatorListBuilder extends SearchOperatorListFluentImpl<SearchOperatorListBuilder> implements VisitableBuilder<SearchOperatorList,SearchOperatorListBuilder>{
  public SearchOperatorListBuilder() {
    this(false);
  }
  public SearchOperatorListBuilder(Boolean validationEnabled) {
    this(new SearchOperatorList(), validationEnabled);
  }
  public SearchOperatorListBuilder(SearchOperatorListFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchOperatorListBuilder(SearchOperatorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchOperatorList(), validationEnabled);
  }
  public SearchOperatorListBuilder(SearchOperatorListFluent<?> fluent,SearchOperatorList instance) {
    this(fluent, instance, false);
  }
  public SearchOperatorListBuilder(SearchOperatorListFluent<?> fluent,SearchOperatorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SearchOperatorListBuilder(SearchOperatorList instance) {
    this(instance,false);
  }
  public SearchOperatorListBuilder(SearchOperatorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  SearchOperatorListFluent<?> fluent;
  Boolean validationEnabled;
  public SearchOperatorList build() {
    SearchOperatorList buildable = new SearchOperatorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}