package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchCustomizationStatusBuilder extends SearchCustomizationStatusFluentImpl<SearchCustomizationStatusBuilder> implements VisitableBuilder<SearchCustomizationStatus,SearchCustomizationStatusBuilder>{
  public SearchCustomizationStatusBuilder() {
    this(false);
  }
  public SearchCustomizationStatusBuilder(Boolean validationEnabled) {
    this(new SearchCustomizationStatus(), validationEnabled);
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchCustomizationStatus(), validationEnabled);
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatusFluent<?> fluent,SearchCustomizationStatus instance) {
    this(fluent, instance, false);
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatusFluent<?> fluent,SearchCustomizationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPersistence(instance.getPersistence());
      fluent.withStorageClass(instance.getStorageClass());
      fluent.withStorageSize(instance.getStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatus instance) {
    this(instance,false);
  }
  public SearchCustomizationStatusBuilder(SearchCustomizationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPersistence(instance.getPersistence());
      this.withStorageClass(instance.getStorageClass());
      this.withStorageSize(instance.getStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  SearchCustomizationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SearchCustomizationStatus build() {
    SearchCustomizationStatus buildable = new SearchCustomizationStatus(fluent.getPersistence(),fluent.getStorageClass(),fluent.getStorageSize());
    return buildable;
  }
  
}