package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchCustomizationSpecBuilder extends SearchCustomizationSpecFluentImpl<SearchCustomizationSpecBuilder> implements VisitableBuilder<SearchCustomizationSpec,SearchCustomizationSpecBuilder>{
  public SearchCustomizationSpecBuilder() {
    this(false);
  }
  public SearchCustomizationSpecBuilder(Boolean validationEnabled) {
    this(new SearchCustomizationSpec(), validationEnabled);
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchCustomizationSpec(), validationEnabled);
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpecFluent<?> fluent,SearchCustomizationSpec instance) {
    this(fluent, instance, false);
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpecFluent<?> fluent,SearchCustomizationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPersistence(instance.getPersistence());
      fluent.withStorageClass(instance.getStorageClass());
      fluent.withStorageSize(instance.getStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpec instance) {
    this(instance,false);
  }
  public SearchCustomizationSpecBuilder(SearchCustomizationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPersistence(instance.getPersistence());
      this.withStorageClass(instance.getStorageClass());
      this.withStorageSize(instance.getStorageSize());
    }
    this.validationEnabled = validationEnabled; 
  }
  SearchCustomizationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SearchCustomizationSpec build() {
    SearchCustomizationSpec buildable = new SearchCustomizationSpec(fluent.getPersistence(),fluent.getStorageClass(),fluent.getStorageSize());
    return buildable;
  }
  
}