package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchCustomizationListBuilder extends SearchCustomizationListFluentImpl<SearchCustomizationListBuilder> implements VisitableBuilder<SearchCustomizationList,SearchCustomizationListBuilder>{
  public SearchCustomizationListBuilder() {
    this(false);
  }
  public SearchCustomizationListBuilder(Boolean validationEnabled) {
    this(new SearchCustomizationList(), validationEnabled);
  }
  public SearchCustomizationListBuilder(SearchCustomizationListFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchCustomizationListBuilder(SearchCustomizationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchCustomizationList(), validationEnabled);
  }
  public SearchCustomizationListBuilder(SearchCustomizationListFluent<?> fluent,SearchCustomizationList instance) {
    this(fluent, instance, false);
  }
  public SearchCustomizationListBuilder(SearchCustomizationListFluent<?> fluent,SearchCustomizationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SearchCustomizationListBuilder(SearchCustomizationList instance) {
    this(instance,false);
  }
  public SearchCustomizationListBuilder(SearchCustomizationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  SearchCustomizationListFluent<?> fluent;
  Boolean validationEnabled;
  public SearchCustomizationList build() {
    SearchCustomizationList buildable = new SearchCustomizationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}