package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodResourceBuilder extends PodResourceFluentImpl<PodResourceBuilder> implements VisitableBuilder<PodResource,PodResourceBuilder>{
  public PodResourceBuilder() {
    this(false);
  }
  public PodResourceBuilder(Boolean validationEnabled) {
    this(new PodResource(), validationEnabled);
  }
  public PodResourceBuilder(PodResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PodResourceBuilder(PodResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodResource(), validationEnabled);
  }
  public PodResourceBuilder(PodResourceFluent<?> fluent,PodResource instance) {
    this(fluent, instance, false);
  }
  public PodResourceBuilder(PodResourceFluent<?> fluent,PodResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLimitCpu(instance.getLimitCpu());
      fluent.withLimitMemory(instance.getLimitMemory());
      fluent.withRequestCpu(instance.getRequestCpu());
      fluent.withRequestMemory(instance.getRequestMemory());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodResourceBuilder(PodResource instance) {
    this(instance,false);
  }
  public PodResourceBuilder(PodResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLimitCpu(instance.getLimitCpu());
      this.withLimitMemory(instance.getLimitMemory());
      this.withRequestCpu(instance.getRequestCpu());
      this.withRequestMemory(instance.getRequestMemory());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodResourceFluent<?> fluent;
  Boolean validationEnabled;
  public PodResource build() {
    PodResource buildable = new PodResource(fluent.getLimitCpu(),fluent.getLimitMemory(),fluent.getRequestCpu(),fluent.getRequestMemory());
    return buildable;
  }
  
}