package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SearchOperatorSpecFluentImpl<A extends SearchOperatorSpecFluent<A>> extends BaseFluent<A> implements SearchOperatorSpecFluent<A>{
  public SearchOperatorSpecFluentImpl() {
  }
  public SearchOperatorSpecFluentImpl(SearchOperatorSpec instance) {
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withPullpolicy(instance.getPullpolicy()); 
    this.withPullsecret(instance.getPullsecret()); 
    this.withRedisgraphResource(instance.getRedisgraphResource()); 
    this.withSearchimageoverrides(instance.getSearchimageoverrides()); 
  }
  private Map<String,String> nodeSelector;
  private String pullpolicy;
  private String pullsecret;
  private PodResourceBuilder redisgraphResource;
  private ImageOverridesBuilder searchimageoverrides;
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public String getPullpolicy() {
    return this.pullpolicy;
  }
  public A withPullpolicy(String pullpolicy) {
    this.pullpolicy=pullpolicy; return (A) this;
  }
  public Boolean hasPullpolicy() {
    return this.pullpolicy != null;
  }
  public String getPullsecret() {
    return this.pullsecret;
  }
  public A withPullsecret(String pullsecret) {
    this.pullsecret=pullsecret; return (A) this;
  }
  public Boolean hasPullsecret() {
    return this.pullsecret != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRedisgraphResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodResource getRedisgraphResource() {
    return this.redisgraphResource!=null ?this.redisgraphResource.build():null;
  }
  public PodResource buildRedisgraphResource() {
    return this.redisgraphResource!=null ?this.redisgraphResource.build():null;
  }
  public A withRedisgraphResource(PodResource redisgraphResource) {
    _visitables.get("redisgraphResource").remove(this.redisgraphResource);
    if (redisgraphResource!=null){ this.redisgraphResource= new PodResourceBuilder(redisgraphResource); _visitables.get("redisgraphResource").add(this.redisgraphResource);} else { this.redisgraphResource = null; _visitables.get("redisgraphResource").remove(this.redisgraphResource); } return (A) this;
  }
  public Boolean hasRedisgraphResource() {
    return this.redisgraphResource != null;
  }
  public A withNewRedisgraphResource(String limitCpu,String limitMemory,String requestCpu,String requestMemory) {
    return (A)withRedisgraphResource(new PodResource(limitCpu, limitMemory, requestCpu, requestMemory));
  }
  public SearchOperatorSpecFluent.RedisgraphResourceNested<A> withNewRedisgraphResource() {
    return new SearchOperatorSpecFluentImpl.RedisgraphResourceNestedImpl();
  }
  public SearchOperatorSpecFluent.RedisgraphResourceNested<A> withNewRedisgraphResourceLike(PodResource item) {
    return new SearchOperatorSpecFluentImpl.RedisgraphResourceNestedImpl(item);
  }
  public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editRedisgraphResource() {
    return withNewRedisgraphResourceLike(getRedisgraphResource());
  }
  public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editOrNewRedisgraphResource() {
    return withNewRedisgraphResourceLike(getRedisgraphResource() != null ? getRedisgraphResource(): new PodResourceBuilder().build());
  }
  public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editOrNewRedisgraphResourceLike(PodResource item) {
    return withNewRedisgraphResourceLike(getRedisgraphResource() != null ? getRedisgraphResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSearchimageoverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageOverrides getSearchimageoverrides() {
    return this.searchimageoverrides!=null ?this.searchimageoverrides.build():null;
  }
  public ImageOverrides buildSearchimageoverrides() {
    return this.searchimageoverrides!=null ?this.searchimageoverrides.build():null;
  }
  public A withSearchimageoverrides(ImageOverrides searchimageoverrides) {
    _visitables.get("searchimageoverrides").remove(this.searchimageoverrides);
    if (searchimageoverrides!=null){ this.searchimageoverrides= new ImageOverridesBuilder(searchimageoverrides); _visitables.get("searchimageoverrides").add(this.searchimageoverrides);} else { this.searchimageoverrides = null; _visitables.get("searchimageoverrides").remove(this.searchimageoverrides); } return (A) this;
  }
  public Boolean hasSearchimageoverrides() {
    return this.searchimageoverrides != null;
  }
  public A withNewSearchimageoverrides(String redisgraphTls,String searchAggregator,String searchApi,String searchCollector) {
    return (A)withSearchimageoverrides(new ImageOverrides(redisgraphTls, searchAggregator, searchApi, searchCollector));
  }
  public SearchOperatorSpecFluent.SearchimageoverridesNested<A> withNewSearchimageoverrides() {
    return new SearchOperatorSpecFluentImpl.SearchimageoverridesNestedImpl();
  }
  public SearchOperatorSpecFluent.SearchimageoverridesNested<A> withNewSearchimageoverridesLike(ImageOverrides item) {
    return new SearchOperatorSpecFluentImpl.SearchimageoverridesNestedImpl(item);
  }
  public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editSearchimageoverrides() {
    return withNewSearchimageoverridesLike(getSearchimageoverrides());
  }
  public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editOrNewSearchimageoverrides() {
    return withNewSearchimageoverridesLike(getSearchimageoverrides() != null ? getSearchimageoverrides(): new ImageOverridesBuilder().build());
  }
  public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editOrNewSearchimageoverridesLike(ImageOverrides item) {
    return withNewSearchimageoverridesLike(getSearchimageoverrides() != null ? getSearchimageoverrides(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchOperatorSpecFluentImpl that = (SearchOperatorSpecFluentImpl) o;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (pullpolicy != null ? !pullpolicy.equals(that.pullpolicy) :that.pullpolicy != null) return false;
    if (pullsecret != null ? !pullsecret.equals(that.pullsecret) :that.pullsecret != null) return false;
    if (redisgraphResource != null ? !redisgraphResource.equals(that.redisgraphResource) :that.redisgraphResource != null) return false;
    if (searchimageoverrides != null ? !searchimageoverrides.equals(that.searchimageoverrides) :that.searchimageoverrides != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nodeSelector,  pullpolicy,  pullsecret,  redisgraphResource,  searchimageoverrides,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (pullpolicy != null) { sb.append("pullpolicy:"); sb.append(pullpolicy + ","); }
    if (pullsecret != null) { sb.append("pullsecret:"); sb.append(pullsecret + ","); }
    if (redisgraphResource != null) { sb.append("redisgraphResource:"); sb.append(redisgraphResource + ","); }
    if (searchimageoverrides != null) { sb.append("searchimageoverrides:"); sb.append(searchimageoverrides); }
    sb.append("}");
    return sb.toString();
  }
  class RedisgraphResourceNestedImpl<N> extends PodResourceFluentImpl<SearchOperatorSpecFluent.RedisgraphResourceNested<N>> implements SearchOperatorSpecFluent.RedisgraphResourceNested<N>,Nested<N>{
    RedisgraphResourceNestedImpl(PodResource item) {
      this.builder = new PodResourceBuilder(this, item);
    }
    RedisgraphResourceNestedImpl() {
      this.builder = new PodResourceBuilder(this);
    }
    PodResourceBuilder builder;
    public N and() {
      return (N) SearchOperatorSpecFluentImpl.this.withRedisgraphResource(builder.build());
    }
    public N endRedisgraphResource() {
      return and();
    }
    
  }
  class SearchimageoverridesNestedImpl<N> extends ImageOverridesFluentImpl<SearchOperatorSpecFluent.SearchimageoverridesNested<N>> implements SearchOperatorSpecFluent.SearchimageoverridesNested<N>,Nested<N>{
    SearchimageoverridesNestedImpl(ImageOverrides item) {
      this.builder = new ImageOverridesBuilder(this, item);
    }
    SearchimageoverridesNestedImpl() {
      this.builder = new ImageOverridesBuilder(this);
    }
    ImageOverridesBuilder builder;
    public N and() {
      return (N) SearchOperatorSpecFluentImpl.this.withSearchimageoverrides(builder.build());
    }
    public N endSearchimageoverrides() {
      return and();
    }
    
  }
  
}