package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchOperatorStatusBuilder extends SearchOperatorStatusFluentImpl<SearchOperatorStatusBuilder> implements VisitableBuilder<SearchOperatorStatus,SearchOperatorStatusBuilder>{
  public SearchOperatorStatusBuilder() {
    this(false);
  }
  public SearchOperatorStatusBuilder(Boolean validationEnabled) {
    this(new SearchOperatorStatus(), validationEnabled);
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchOperatorStatus(), validationEnabled);
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatusFluent<?> fluent,SearchOperatorStatus instance) {
    this(fluent, instance, false);
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatusFluent<?> fluent,SearchOperatorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDeployredisgraph(instance.getDeployredisgraph()); 
    fluent.withPersistence(instance.getPersistence()); 
    this.validationEnabled = validationEnabled; 
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatus instance) {
    this(instance,false);
  }
  public SearchOperatorStatusBuilder(SearchOperatorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDeployredisgraph(instance.getDeployredisgraph()); 
    this.withPersistence(instance.getPersistence()); 
    this.validationEnabled = validationEnabled; 
  }
  SearchOperatorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SearchOperatorStatus build() {
    SearchOperatorStatus buildable = new SearchOperatorStatus(fluent.getDeployredisgraph(),fluent.getPersistence());
    return buildable;
  }
  
}