package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SearchCustomizationBuilder extends SearchCustomizationFluentImpl<SearchCustomizationBuilder> implements VisitableBuilder<SearchCustomization,SearchCustomizationBuilder>{
  public SearchCustomizationBuilder() {
    this(false);
  }
  public SearchCustomizationBuilder(Boolean validationEnabled) {
    this(new SearchCustomization(), validationEnabled);
  }
  public SearchCustomizationBuilder(SearchCustomizationFluent<?> fluent) {
    this(fluent, false);
  }
  public SearchCustomizationBuilder(SearchCustomizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SearchCustomization(), validationEnabled);
  }
  public SearchCustomizationBuilder(SearchCustomizationFluent<?> fluent,SearchCustomization instance) {
    this(fluent, instance, false);
  }
  public SearchCustomizationBuilder(SearchCustomizationFluent<?> fluent,SearchCustomization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public SearchCustomizationBuilder(SearchCustomization instance) {
    this(instance,false);
  }
  public SearchCustomizationBuilder(SearchCustomization instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  SearchCustomizationFluent<?> fluent;
  Boolean validationEnabled;
  public SearchCustomization build() {
    SearchCustomization buildable = new SearchCustomization(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}