package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SearchOperatorSpecFluent<A extends SearchOperatorSpecFluent<A>> extends BaseFluent<A>{
  public SearchOperatorSpecFluent() {
  }
  
  public SearchOperatorSpecFluent(SearchOperatorSpec instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> nodeSelector;
  private String pullpolicy;
  private String pullsecret;
  private PodResourceBuilder redisgraphResource;
  private ImageOverridesBuilder searchimageoverrides;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SearchOperatorSpec instance) {
    instance = (instance != null ? instance : new SearchOperatorSpec());
    if (instance != null) {
          this.withNodeSelector(instance.getNodeSelector());
          this.withPullpolicy(instance.getPullpolicy());
          this.withPullsecret(instance.getPullsecret());
          this.withRedisgraphResource(instance.getRedisgraphResource());
          this.withSearchimageoverrides(instance.getSearchimageoverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) {
      this.nodeSelector = null;
    } else {
      this.nodeSelector = new LinkedHashMap(nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public String getPullpolicy() {
    return this.pullpolicy;
  }
  
  public A withPullpolicy(String pullpolicy) {
    this.pullpolicy = pullpolicy;
    return (A) this;
  }
  
  public boolean hasPullpolicy() {
    return this.pullpolicy != null;
  }
  
  public String getPullsecret() {
    return this.pullsecret;
  }
  
  public A withPullsecret(String pullsecret) {
    this.pullsecret = pullsecret;
    return (A) this;
  }
  
  public boolean hasPullsecret() {
    return this.pullsecret != null;
  }
  
  public PodResource buildRedisgraphResource() {
    return this.redisgraphResource != null ? this.redisgraphResource.build() : null;
  }
  
  public A withRedisgraphResource(PodResource redisgraphResource) {
    this._visitables.remove("redisgraphResource");
    if (redisgraphResource != null) {
        this.redisgraphResource = new PodResourceBuilder(redisgraphResource);
        this._visitables.get("redisgraphResource").add(this.redisgraphResource);
    } else {
        this.redisgraphResource = null;
        this._visitables.get("redisgraphResource").remove(this.redisgraphResource);
    }
    return (A) this;
  }
  
  public boolean hasRedisgraphResource() {
    return this.redisgraphResource != null;
  }
  
  public A withNewRedisgraphResource(String limitCpu,String limitMemory,String requestCpu,String requestMemory) {
    return (A)withRedisgraphResource(new PodResource(limitCpu, limitMemory, requestCpu, requestMemory));
  }
  
  public RedisgraphResourceNested<A> withNewRedisgraphResource() {
    return new RedisgraphResourceNested(null);
  }
  
  public RedisgraphResourceNested<A> withNewRedisgraphResourceLike(PodResource item) {
    return new RedisgraphResourceNested(item);
  }
  
  public RedisgraphResourceNested<A> editRedisgraphResource() {
    return withNewRedisgraphResourceLike(java.util.Optional.ofNullable(buildRedisgraphResource()).orElse(null));
  }
  
  public RedisgraphResourceNested<A> editOrNewRedisgraphResource() {
    return withNewRedisgraphResourceLike(java.util.Optional.ofNullable(buildRedisgraphResource()).orElse(new PodResourceBuilder().build()));
  }
  
  public RedisgraphResourceNested<A> editOrNewRedisgraphResourceLike(PodResource item) {
    return withNewRedisgraphResourceLike(java.util.Optional.ofNullable(buildRedisgraphResource()).orElse(item));
  }
  
  public ImageOverrides buildSearchimageoverrides() {
    return this.searchimageoverrides != null ? this.searchimageoverrides.build() : null;
  }
  
  public A withSearchimageoverrides(ImageOverrides searchimageoverrides) {
    this._visitables.remove("searchimageoverrides");
    if (searchimageoverrides != null) {
        this.searchimageoverrides = new ImageOverridesBuilder(searchimageoverrides);
        this._visitables.get("searchimageoverrides").add(this.searchimageoverrides);
    } else {
        this.searchimageoverrides = null;
        this._visitables.get("searchimageoverrides").remove(this.searchimageoverrides);
    }
    return (A) this;
  }
  
  public boolean hasSearchimageoverrides() {
    return this.searchimageoverrides != null;
  }
  
  public A withNewSearchimageoverrides(String redisgraphTls,String searchAggregator,String searchApi,String searchCollector) {
    return (A)withSearchimageoverrides(new ImageOverrides(redisgraphTls, searchAggregator, searchApi, searchCollector));
  }
  
  public SearchimageoverridesNested<A> withNewSearchimageoverrides() {
    return new SearchimageoverridesNested(null);
  }
  
  public SearchimageoverridesNested<A> withNewSearchimageoverridesLike(ImageOverrides item) {
    return new SearchimageoverridesNested(item);
  }
  
  public SearchimageoverridesNested<A> editSearchimageoverrides() {
    return withNewSearchimageoverridesLike(java.util.Optional.ofNullable(buildSearchimageoverrides()).orElse(null));
  }
  
  public SearchimageoverridesNested<A> editOrNewSearchimageoverrides() {
    return withNewSearchimageoverridesLike(java.util.Optional.ofNullable(buildSearchimageoverrides()).orElse(new ImageOverridesBuilder().build()));
  }
  
  public SearchimageoverridesNested<A> editOrNewSearchimageoverridesLike(ImageOverrides item) {
    return withNewSearchimageoverridesLike(java.util.Optional.ofNullable(buildSearchimageoverrides()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SearchOperatorSpecFluent that = (SearchOperatorSpecFluent) o;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(pullpolicy, that.pullpolicy)) return false;
    if (!java.util.Objects.equals(pullsecret, that.pullsecret)) return false;
    if (!java.util.Objects.equals(redisgraphResource, that.redisgraphResource)) return false;
    if (!java.util.Objects.equals(searchimageoverrides, that.searchimageoverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nodeSelector,  pullpolicy,  pullsecret,  redisgraphResource,  searchimageoverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (pullpolicy != null) { sb.append("pullpolicy:"); sb.append(pullpolicy + ","); }
    if (pullsecret != null) { sb.append("pullsecret:"); sb.append(pullsecret + ","); }
    if (redisgraphResource != null) { sb.append("redisgraphResource:"); sb.append(redisgraphResource + ","); }
    if (searchimageoverrides != null) { sb.append("searchimageoverrides:"); sb.append(searchimageoverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RedisgraphResourceNested<N> extends PodResourceFluent<RedisgraphResourceNested<N>> implements Nested<N>{
    RedisgraphResourceNested(PodResource item) {
      this.builder = new PodResourceBuilder(this, item);
    }
    PodResourceBuilder builder;
    
    public N and() {
      return (N) SearchOperatorSpecFluent.this.withRedisgraphResource(builder.build());
    }
    
    public N endRedisgraphResource() {
      return and();
    }
    
  
  }
  public class SearchimageoverridesNested<N> extends ImageOverridesFluent<SearchimageoverridesNested<N>> implements Nested<N>{
    SearchimageoverridesNested(ImageOverrides item) {
      this.builder = new ImageOverridesBuilder(this, item);
    }
    ImageOverridesBuilder builder;
    
    public N and() {
      return (N) SearchOperatorSpecFluent.this.withSearchimageoverrides(builder.build());
    }
    
    public N endSearchimageoverrides() {
      return and();
    }
    
  
  }

}