package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodResourceBuilder extends PodResourceFluent<PodResourceBuilder> implements VisitableBuilder<PodResource,PodResourceBuilder>{
  public PodResourceBuilder() {
    this(new PodResource());
  }
  
  public PodResourceBuilder(PodResourceFluent<?> fluent) {
    this(fluent, new PodResource());
  }
  
  public PodResourceBuilder(PodResourceFluent<?> fluent,PodResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodResourceBuilder(PodResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodResourceFluent<?> fluent;
  
  public PodResource build() {
    PodResource buildable = new PodResource(fluent.getLimitCpu(),fluent.getLimitMemory(),fluent.getRequestCpu(),fluent.getRequestMemory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}