package io.fabric8.openclustermanagement.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenClusterManagementSearchSchemaBuilder extends OpenClusterManagementSearchSchemaFluent<OpenClusterManagementSearchSchemaBuilder> implements VisitableBuilder<OpenClusterManagementSearchSchema,OpenClusterManagementSearchSchemaBuilder>{
  public OpenClusterManagementSearchSchemaBuilder() {
    this(new OpenClusterManagementSearchSchema());
  }
  
  public OpenClusterManagementSearchSchemaBuilder(OpenClusterManagementSearchSchemaFluent<?> fluent) {
    this(fluent, new OpenClusterManagementSearchSchema());
  }
  
  public OpenClusterManagementSearchSchemaBuilder(OpenClusterManagementSearchSchemaFluent<?> fluent,OpenClusterManagementSearchSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenClusterManagementSearchSchemaBuilder(OpenClusterManagementSearchSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenClusterManagementSearchSchemaFluent<?> fluent;
  
  public OpenClusterManagementSearchSchema build() {
    OpenClusterManagementSearchSchema buildable = new OpenClusterManagementSearchSchema(fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1ImageOverrides(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1PodResource(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchCustomization(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchCustomizationList(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchCustomizationSpec(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchCustomizationStatus(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchOperator(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchOperatorList(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchOperatorSpec(),fluent.buildGithubComOpenClusterManagementSearchOperatorApiV1alpha1SearchOperatorStatus());
    return buildable;
  }
  

}