package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageOverridesBuilder extends ImageOverridesFluentImpl<ImageOverridesBuilder> implements VisitableBuilder<ImageOverrides,ImageOverridesBuilder>{
  public ImageOverridesBuilder() {
    this(false);
  }
  public ImageOverridesBuilder(Boolean validationEnabled) {
    this(new ImageOverrides(), validationEnabled);
  }
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageOverrides(), validationEnabled);
  }
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent,ImageOverrides instance) {
    this(fluent, instance, false);
  }
  public ImageOverridesBuilder(ImageOverridesFluent<?> fluent,ImageOverrides instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRedisgraphTls(instance.getRedisgraphTls()); 
    fluent.withSearchAggregator(instance.getSearchAggregator()); 
    fluent.withSearchApi(instance.getSearchApi()); 
    fluent.withSearchCollector(instance.getSearchCollector()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageOverridesBuilder(ImageOverrides instance) {
    this(instance,false);
  }
  public ImageOverridesBuilder(ImageOverrides instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRedisgraphTls(instance.getRedisgraphTls()); 
    this.withSearchAggregator(instance.getSearchAggregator()); 
    this.withSearchApi(instance.getSearchApi()); 
    this.withSearchCollector(instance.getSearchCollector()); 
    this.validationEnabled = validationEnabled; 
  }
  ImageOverridesFluent<?> fluent;
  Boolean validationEnabled;
  public ImageOverrides build() {
    ImageOverrides buildable = new ImageOverrides(fluent.getRedisgraphTls(),fluent.getSearchAggregator(),fluent.getSearchApi(),fluent.getSearchCollector());
    return buildable;
  }
  
}