package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodResourceBuilder extends PodResourceFluentImpl<PodResourceBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceBuilder>{
  public PodResourceBuilder() {
    this(false);
  }
  public PodResourceBuilder(Boolean validationEnabled) {
    this(new PodResource(), validationEnabled);
  }
  public PodResourceBuilder(PodResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PodResourceBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodResource(), validationEnabled);
  }
  public PodResourceBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluent<?> fluent,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource instance) {
    this(fluent, instance, false);
  }
  public PodResourceBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluent<?> fluent,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLimitCpu(instance.getLimitCpu()); 
    fluent.withLimitMemory(instance.getLimitMemory()); 
    fluent.withRequestCpu(instance.getRequestCpu()); 
    fluent.withRequestMemory(instance.getRequestMemory()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodResourceBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource instance) {
    this(instance,false);
  }
  public PodResourceBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLimitCpu(instance.getLimitCpu()); 
    this.withLimitMemory(instance.getLimitMemory()); 
    this.withRequestCpu(instance.getRequestCpu()); 
    this.withRequestMemory(instance.getRequestMemory()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource build() {
    PodResource buildable = new PodResource(fluent.getLimitCpu(),fluent.getLimitMemory(),fluent.getRequestCpu(),fluent.getRequestMemory());
    return buildable;
  }
  
}