package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageOverridesBuilder extends ImageOverridesFluentImpl<ImageOverridesBuilder> implements VisitableBuilder<ImageOverrides,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesBuilder>{
  public ImageOverridesBuilder() {
    this(false);
  }
  public ImageOverridesBuilder(Boolean validationEnabled) {
    this(new ImageOverrides(), validationEnabled);
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageOverrides(), validationEnabled);
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent<?> fluent,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides instance) {
    this(fluent, instance, false);
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent<?> fluent,io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRedisgraphTls(instance.getRedisgraphTls()); 
    fluent.withSearchAggregator(instance.getSearchAggregator()); 
    fluent.withSearchApi(instance.getSearchApi()); 
    fluent.withSearchCollector(instance.getSearchCollector()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides instance) {
    this(instance,false);
  }
  public ImageOverridesBuilder(io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRedisgraphTls(instance.getRedisgraphTls()); 
    this.withSearchAggregator(instance.getSearchAggregator()); 
    this.withSearchApi(instance.getSearchApi()); 
    this.withSearchCollector(instance.getSearchCollector()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides build() {
    ImageOverrides buildable = new ImageOverrides(fluent.getRedisgraphTls(),fluent.getSearchAggregator(),fluent.getSearchApi(),fluent.getSearchCollector());
    return buildable;
  }
  
}