/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverrides;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesBuilder;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.ImageOverridesFluentImpl;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResource;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceBuilder;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.PodResourceFluentImpl;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorSpec;
import io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1.SearchOperatorSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SearchOperatorSpecFluentImpl<A extends SearchOperatorSpecFluent<A>>
extends BaseFluent<A>
implements SearchOperatorSpecFluent<A> {
    private Map<String, String> nodeSelector;
    private String pullpolicy;
    private String pullsecret;
    private PodResourceBuilder redisgraphResource;
    private ImageOverridesBuilder searchimageoverrides;

    public SearchOperatorSpecFluentImpl() {
    }

    public SearchOperatorSpecFluentImpl(SearchOperatorSpec instance) {
        this.withNodeSelector(instance.getNodeSelector());
        this.withPullpolicy(instance.getPullpolicy());
        this.withPullsecret(instance.getPullsecret());
        this.withRedisgraphResource(instance.getRedisgraphResource());
        this.withSearchimageoverrides(instance.getSearchimageoverrides());
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public String getPullpolicy() {
        return this.pullpolicy;
    }

    @Override
    public A withPullpolicy(String pullpolicy) {
        this.pullpolicy = pullpolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPullpolicy() {
        return this.pullpolicy != null;
    }

    @Override
    @Deprecated
    public A withNewPullpolicy(String arg0) {
        return this.withPullpolicy(new String(arg0));
    }

    @Override
    public String getPullsecret() {
        return this.pullsecret;
    }

    @Override
    public A withPullsecret(String pullsecret) {
        this.pullsecret = pullsecret;
        return (A)this;
    }

    @Override
    public Boolean hasPullsecret() {
        return this.pullsecret != null;
    }

    @Override
    @Deprecated
    public A withNewPullsecret(String arg0) {
        return this.withPullsecret(new String(arg0));
    }

    @Override
    @Deprecated
    public PodResource getRedisgraphResource() {
        return this.redisgraphResource != null ? this.redisgraphResource.build() : null;
    }

    @Override
    public PodResource buildRedisgraphResource() {
        return this.redisgraphResource != null ? this.redisgraphResource.build() : null;
    }

    @Override
    public A withRedisgraphResource(PodResource redisgraphResource) {
        this._visitables.get((Object)"redisgraphResource").remove(this.redisgraphResource);
        if (redisgraphResource != null) {
            this.redisgraphResource = new PodResourceBuilder(redisgraphResource);
            this._visitables.get((Object)"redisgraphResource").add(this.redisgraphResource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedisgraphResource() {
        return this.redisgraphResource != null;
    }

    @Override
    public A withNewRedisgraphResource(String limitCpu, String limitMemory, String requestCpu, String requestMemory) {
        return this.withRedisgraphResource(new PodResource(limitCpu, limitMemory, requestCpu, requestMemory));
    }

    @Override
    public SearchOperatorSpecFluent.RedisgraphResourceNested<A> withNewRedisgraphResource() {
        return new RedisgraphResourceNestedImpl();
    }

    @Override
    public SearchOperatorSpecFluent.RedisgraphResourceNested<A> withNewRedisgraphResourceLike(PodResource item) {
        return new RedisgraphResourceNestedImpl(item);
    }

    @Override
    public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editRedisgraphResource() {
        return this.withNewRedisgraphResourceLike(this.getRedisgraphResource());
    }

    @Override
    public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editOrNewRedisgraphResource() {
        return this.withNewRedisgraphResourceLike(this.getRedisgraphResource() != null ? this.getRedisgraphResource() : new PodResourceBuilder().build());
    }

    @Override
    public SearchOperatorSpecFluent.RedisgraphResourceNested<A> editOrNewRedisgraphResourceLike(PodResource item) {
        return this.withNewRedisgraphResourceLike(this.getRedisgraphResource() != null ? this.getRedisgraphResource() : item);
    }

    @Override
    @Deprecated
    public ImageOverrides getSearchimageoverrides() {
        return this.searchimageoverrides != null ? this.searchimageoverrides.build() : null;
    }

    @Override
    public ImageOverrides buildSearchimageoverrides() {
        return this.searchimageoverrides != null ? this.searchimageoverrides.build() : null;
    }

    @Override
    public A withSearchimageoverrides(ImageOverrides searchimageoverrides) {
        this._visitables.get((Object)"searchimageoverrides").remove(this.searchimageoverrides);
        if (searchimageoverrides != null) {
            this.searchimageoverrides = new ImageOverridesBuilder(searchimageoverrides);
            this._visitables.get((Object)"searchimageoverrides").add(this.searchimageoverrides);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearchimageoverrides() {
        return this.searchimageoverrides != null;
    }

    @Override
    public A withNewSearchimageoverrides(String redisgraphTls, String searchAggregator, String searchApi, String searchCollector) {
        return this.withSearchimageoverrides(new ImageOverrides(redisgraphTls, searchAggregator, searchApi, searchCollector));
    }

    @Override
    public SearchOperatorSpecFluent.SearchimageoverridesNested<A> withNewSearchimageoverrides() {
        return new SearchimageoverridesNestedImpl();
    }

    @Override
    public SearchOperatorSpecFluent.SearchimageoverridesNested<A> withNewSearchimageoverridesLike(ImageOverrides item) {
        return new SearchimageoverridesNestedImpl(item);
    }

    @Override
    public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editSearchimageoverrides() {
        return this.withNewSearchimageoverridesLike(this.getSearchimageoverrides());
    }

    @Override
    public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editOrNewSearchimageoverrides() {
        return this.withNewSearchimageoverridesLike(this.getSearchimageoverrides() != null ? this.getSearchimageoverrides() : new ImageOverridesBuilder().build());
    }

    @Override
    public SearchOperatorSpecFluent.SearchimageoverridesNested<A> editOrNewSearchimageoverridesLike(ImageOverrides item) {
        return this.withNewSearchimageoverridesLike(this.getSearchimageoverrides() != null ? this.getSearchimageoverrides() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchOperatorSpecFluentImpl that = (SearchOperatorSpecFluentImpl)o;
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.pullpolicy != null ? !this.pullpolicy.equals(that.pullpolicy) : that.pullpolicy != null) {
            return false;
        }
        if (this.pullsecret != null ? !this.pullsecret.equals(that.pullsecret) : that.pullsecret != null) {
            return false;
        }
        if (this.redisgraphResource != null ? !this.redisgraphResource.equals(that.redisgraphResource) : that.redisgraphResource != null) {
            return false;
        }
        return !(this.searchimageoverrides != null ? !this.searchimageoverrides.equals(that.searchimageoverrides) : that.searchimageoverrides != null);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector, this.pullpolicy, this.pullsecret, this.redisgraphResource, this.searchimageoverrides, super.hashCode());
    }

    public class SearchimageoverridesNestedImpl<N>
    extends ImageOverridesFluentImpl<SearchOperatorSpecFluent.SearchimageoverridesNested<N>>
    implements SearchOperatorSpecFluent.SearchimageoverridesNested<N>,
    Nested<N> {
        ImageOverridesBuilder builder;

        SearchimageoverridesNestedImpl(ImageOverrides item) {
            this.builder = new ImageOverridesBuilder(this, item);
        }

        SearchimageoverridesNestedImpl() {
            this.builder = new ImageOverridesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SearchOperatorSpecFluentImpl.this.withSearchimageoverrides(this.builder.build());
        }

        @Override
        public N endSearchimageoverrides() {
            return this.and();
        }
    }

    public class RedisgraphResourceNestedImpl<N>
    extends PodResourceFluentImpl<SearchOperatorSpecFluent.RedisgraphResourceNested<N>>
    implements SearchOperatorSpecFluent.RedisgraphResourceNested<N>,
    Nested<N> {
        PodResourceBuilder builder;

        RedisgraphResourceNestedImpl(PodResource item) {
            this.builder = new PodResourceBuilder(this, item);
        }

        RedisgraphResourceNestedImpl() {
            this.builder = new PodResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SearchOperatorSpecFluentImpl.this.withRedisgraphResource(this.builder.build());
        }

        @Override
        public N endRedisgraphResource() {
            return this.and();
        }
    }
}

