
package io.fabric8.openclustermanagement.api.model.searchoperator.v1alpha1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "limit_cpu",
    "limit_memory",
    "request_cpu",
    "request_memory"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class PodResource implements KubernetesResource
{

    @JsonProperty("limit_cpu")
    private String limitCpu;
    @JsonProperty("limit_memory")
    private String limitMemory;
    @JsonProperty("request_cpu")
    private String requestCpu;
    @JsonProperty("request_memory")
    private String requestMemory;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PodResource() {
    }

    /**
     * 
     * @param requestMemory
     * @param limitCpu
     * @param requestCpu
     * @param limitMemory
     */
    public PodResource(String limitCpu, String limitMemory, String requestCpu, String requestMemory) {
        super();
        this.limitCpu = limitCpu;
        this.limitMemory = limitMemory;
        this.requestCpu = requestCpu;
        this.requestMemory = requestMemory;
    }

    @JsonProperty("limit_cpu")
    public String getLimitCpu() {
        return limitCpu;
    }

    @JsonProperty("limit_cpu")
    public void setLimitCpu(String limitCpu) {
        this.limitCpu = limitCpu;
    }

    @JsonProperty("limit_memory")
    public String getLimitMemory() {
        return limitMemory;
    }

    @JsonProperty("limit_memory")
    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    @JsonProperty("request_cpu")
    public String getRequestCpu() {
        return requestCpu;
    }

    @JsonProperty("request_cpu")
    public void setRequestCpu(String requestCpu) {
        this.requestCpu = requestCpu;
    }

    @JsonProperty("request_memory")
    public String getRequestMemory() {
        return requestMemory;
    }

    @JsonProperty("request_memory")
    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
