package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementBindingFluent<A extends PlacementBindingFluent<A>> extends BaseFluent<A>{
  public PlacementBindingFluent() {
  }
  
  public PlacementBindingFluent(PlacementBinding instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PlacementSubjectBuilder placementRef;
  private PlacementBindingStatusBuilder status;
  private ArrayList<SubjectBuilder> subjects = new ArrayList<SubjectBuilder>();
  
  protected void copyInstance(PlacementBinding instance) {
    instance = (instance != null ? instance : new PlacementBinding());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withPlacementRef(instance.getPlacementRef());
          this.withStatus(instance.getStatus());
          this.withSubjects(instance.getSubjects());
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withPlacementRef(instance.getPlacementRef());
          this.withStatus(instance.getStatus());
          this.withSubjects(instance.getSubjects());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove(this.metadata);
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public PlacementSubject buildPlacementRef() {
    return this.placementRef != null ? this.placementRef.build() : null;
  }
  
  public A withPlacementRef(PlacementSubject placementRef) {
    this._visitables.remove(this.placementRef);
    if (placementRef != null) {
        this.placementRef = new PlacementSubjectBuilder(placementRef);
        this._visitables.get("placementRef").add(this.placementRef);
    } else {
        this.placementRef = null;
        this._visitables.get("placementRef").remove(this.placementRef);
    }
    return (A) this;
  }
  
  public boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  
  public A withNewPlacementRef(String apiGroup,String kind,String name) {
    return (A)withPlacementRef(new PlacementSubject(apiGroup, kind, name));
  }
  
  public PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementRefNested(null);
  }
  
  public PlacementRefNested<A> withNewPlacementRefLike(PlacementSubject item) {
    return new PlacementRefNested(item);
  }
  
  public PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(null));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(new PlacementSubjectBuilder().build()));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRefLike(PlacementSubject item) {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(item));
  }
  
  public PlacementBindingStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(PlacementBindingStatus status) {
    this._visitables.remove(this.status);
    if (status != null) {
        this.status = new PlacementBindingStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(PlacementBindingStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new PlacementBindingStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(PlacementBindingStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public A addToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").add(index, builder); subjects.add(index, builder);}
    return (A)this;
  }
  
  public A setToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").set(index, builder); subjects.set(index, builder);}
    return (A)this;
  }
  
  public A addToSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  
  public A addAllToSubjects(Collection<Subject> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  
  public A removeFromSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... items) {
    if (this.subjects == null) return (A)this;
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder); this.subjects.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubjects(Collection<Subject> items) {
    if (this.subjects == null) return (A)this;
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder); this.subjects.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<SubjectBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      SubjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Subject> buildSubjects() {
    return this.subjects != null ? build(subjects) : null;
  }
  
  public Subject buildSubject(int index) {
    return this.subjects.get(index).build();
  }
  
  public Subject buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  
  public Subject buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  
  public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
      for (SubjectBuilder item : subjects) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
      for (SubjectBuilder item : subjects) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubjects(List<Subject> subjects) {
    if (this.subjects != null) {
      this._visitables.get("subjects").clear();
    }
    if (subjects != null) {
        this.subjects = new ArrayList();
        for (Subject item : subjects) {
          this.addToSubjects(item);
        }
    } else {
      this.subjects = null;
    }
    return (A) this;
  }
  
  public A withSubjects(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear(); _visitables.remove("subjects"); }
    if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  
  public boolean hasSubjects() {
    return this.subjects != null && !this.subjects.isEmpty();
  }
  
  public A addNewSubject(String apiGroup,String kind,String name) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name));
  }
  
  public SubjectsNested<A> addNewSubject() {
    return new SubjectsNested(-1, null);
  }
  
  public SubjectsNested<A> addNewSubjectLike(Subject item) {
    return new SubjectsNested(-1, item);
  }
  
  public SubjectsNested<A> setNewSubjectLike(int index,Subject item) {
    return new SubjectsNested(index, item);
  }
  
  public SubjectsNested<A> editSubject(int index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  
  public SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementBindingFluent that = (PlacementBindingFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(subjects, that.subjects)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  placementRef,  status,  subjects,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (subjects != null && !subjects.isEmpty()) { sb.append("subjects:"); sb.append(subjects); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) PlacementBindingFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class PlacementRefNested<N> extends PlacementSubjectFluent<PlacementRefNested<N>> implements Nested<N>{
    PlacementRefNested(PlacementSubject item) {
      this.builder = new PlacementSubjectBuilder(this, item);
    }
    PlacementSubjectBuilder builder;
    
    public N and() {
      return (N) PlacementBindingFluent.this.withPlacementRef(builder.build());
    }
    
    public N endPlacementRef() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends PlacementBindingStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(PlacementBindingStatus item) {
      this.builder = new PlacementBindingStatusBuilder(this, item);
    }
    PlacementBindingStatusBuilder builder;
    
    public N and() {
      return (N) PlacementBindingFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }
  public class SubjectsNested<N> extends SubjectFluent<SubjectsNested<N>> implements Nested<N>{
    SubjectsNested(int index,Subject item) {
      this.index = index;
      this.builder = new SubjectBuilder(this, item);
    }
    SubjectBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementBindingFluent.this.setToSubjects(index,builder.build());
    }
    
    public N endSubject() {
      return and();
    }
    
  
  }

}