/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicySpec;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplateBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicySpecFluent<A extends PolicySpecFluent<A>>
extends BaseFluent<A> {
    private Boolean disabled;
    private ArrayList<PolicyTemplateBuilder> policyTemplates = new ArrayList();
    private String remediationAction;

    public PolicySpecFluent() {
    }

    public PolicySpecFluent(PolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicySpec instance) {
        PolicySpec policySpec = instance = instance != null ? instance : new PolicySpec();
        if (instance != null) {
            this.withDisabled(instance.getDisabled());
            this.withPolicyTemplates(instance.getPolicyTemplates());
            this.withRemediationAction(instance.getRemediationAction());
            this.withDisabled(instance.getDisabled());
            this.withPolicyTemplates(instance.getPolicyTemplates());
            this.withRemediationAction(instance.getRemediationAction());
        }
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public A withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return (A)((Object)this);
    }

    public boolean hasDisabled() {
        return this.disabled != null;
    }

    public A addToPolicyTemplates(int index, PolicyTemplate item) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
        if (index < 0 || index >= this.policyTemplates.size()) {
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        } else {
            this._visitables.get((Object)"policyTemplates").add(index, builder);
            this.policyTemplates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPolicyTemplates(int index, PolicyTemplate item) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
        if (index < 0 || index >= this.policyTemplates.size()) {
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        } else {
            this._visitables.get((Object)"policyTemplates").set(index, builder);
            this.policyTemplates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPolicyTemplates(PolicyTemplate ... items) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicyTemplates(Collection<PolicyTemplate> items) {
        if (this.policyTemplates == null) {
            this.policyTemplates = new ArrayList();
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").add(builder);
            this.policyTemplates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyTemplates(PolicyTemplate ... items) {
        if (this.policyTemplates == null) {
            return (A)((Object)this);
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").remove((Object)builder);
            this.policyTemplates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicyTemplates(Collection<PolicyTemplate> items) {
        if (this.policyTemplates == null) {
            return (A)((Object)this);
        }
        for (PolicyTemplate item : items) {
            PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
            this._visitables.get((Object)"policyTemplates").remove((Object)builder);
            this.policyTemplates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPolicyTemplates(Predicate<PolicyTemplateBuilder> predicate) {
        if (this.policyTemplates == null) {
            return (A)((Object)this);
        }
        Iterator<PolicyTemplateBuilder> each = this.policyTemplates.iterator();
        List visitables = this._visitables.get((Object)"policyTemplates");
        while (each.hasNext()) {
            PolicyTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PolicyTemplate> buildPolicyTemplates() {
        return this.policyTemplates != null ? PolicySpecFluent.build(this.policyTemplates) : null;
    }

    public PolicyTemplate buildPolicyTemplate(int index) {
        return this.policyTemplates.get(index).build();
    }

    public PolicyTemplate buildFirstPolicyTemplate() {
        return this.policyTemplates.get(0).build();
    }

    public PolicyTemplate buildLastPolicyTemplate() {
        return this.policyTemplates.get(this.policyTemplates.size() - 1).build();
    }

    public PolicyTemplate buildMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        for (PolicyTemplateBuilder item : this.policyTemplates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        for (PolicyTemplateBuilder item : this.policyTemplates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicyTemplates(List<PolicyTemplate> policyTemplates) {
        if (this.policyTemplates != null) {
            this._visitables.get((Object)"policyTemplates").clear();
        }
        if (policyTemplates != null) {
            this.policyTemplates = new ArrayList();
            for (PolicyTemplate item : policyTemplates) {
                this.addToPolicyTemplates(item);
            }
        } else {
            this.policyTemplates = null;
        }
        return (A)((Object)this);
    }

    public A withPolicyTemplates(PolicyTemplate ... policyTemplates) {
        if (this.policyTemplates != null) {
            this.policyTemplates.clear();
            this._visitables.remove((Object)"policyTemplates");
        }
        if (policyTemplates != null) {
            for (PolicyTemplate item : policyTemplates) {
                this.addToPolicyTemplates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicyTemplates() {
        return this.policyTemplates != null && !this.policyTemplates.isEmpty();
    }

    public PolicyTemplatesNested<A> addNewPolicyTemplate() {
        return new PolicyTemplatesNested(-1, null);
    }

    public PolicyTemplatesNested<A> addNewPolicyTemplateLike(PolicyTemplate item) {
        return new PolicyTemplatesNested(-1, item);
    }

    public PolicyTemplatesNested<A> setNewPolicyTemplateLike(int index, PolicyTemplate item) {
        return new PolicyTemplatesNested(index, item);
    }

    public PolicyTemplatesNested<A> editPolicyTemplate(int index) {
        if (this.policyTemplates.size() <= index) {
            throw new RuntimeException("Can't edit policyTemplates. Index exceeds size.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    public PolicyTemplatesNested<A> editFirstPolicyTemplate() {
        if (this.policyTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first policyTemplates. The list is empty.");
        }
        return this.setNewPolicyTemplateLike(0, this.buildPolicyTemplate(0));
    }

    public PolicyTemplatesNested<A> editLastPolicyTemplate() {
        int index = this.policyTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policyTemplates. The list is empty.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    public PolicyTemplatesNested<A> editMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policyTemplates.size(); ++i) {
            if (!predicate.test(this.policyTemplates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policyTemplates. No match found.");
        }
        return this.setNewPolicyTemplateLike(index, this.buildPolicyTemplate(index));
    }

    public String getRemediationAction() {
        return this.remediationAction;
    }

    public A withRemediationAction(String remediationAction) {
        this.remediationAction = remediationAction;
        return (A)((Object)this);
    }

    public boolean hasRemediationAction() {
        return this.remediationAction != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicySpecFluent that = (PolicySpecFluent)((Object)o);
        if (!Objects.equals(this.disabled, that.disabled)) {
            return false;
        }
        if (!Objects.equals(this.policyTemplates, that.policyTemplates)) {
            return false;
        }
        return Objects.equals(this.remediationAction, that.remediationAction);
    }

    public int hashCode() {
        return Objects.hash(this.disabled, this.policyTemplates, this.remediationAction, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disabled != null) {
            sb.append("disabled:");
            sb.append(this.disabled + ",");
        }
        if (this.policyTemplates != null && !this.policyTemplates.isEmpty()) {
            sb.append("policyTemplates:");
            sb.append(this.policyTemplates + ",");
        }
        if (this.remediationAction != null) {
            sb.append("remediationAction:");
            sb.append(this.remediationAction);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisabled() {
        return this.withDisabled(true);
    }

    public class PolicyTemplatesNested<N>
    extends PolicyTemplateFluent<PolicyTemplatesNested<N>>
    implements Nested<N> {
        PolicyTemplateBuilder builder;
        int index;

        PolicyTemplatesNested(int index, PolicyTemplate item) {
            this.index = index;
            this.builder = new PolicyTemplateBuilder(this, item);
        }

        public N and() {
            return (N)PolicySpecFluent.this.setToPolicyTemplates(this.index, this.builder.build());
        }

        public N endPolicyTemplate() {
            return this.and();
        }
    }
}

