package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecisionFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecisionBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecision;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementFluent<A extends PlacementFluent<A>> extends BaseFluent<A>{
  public PlacementFluent() {
  }
  
  public PlacementFluent(Placement instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PlacementDecisionBuilder> decisions = new ArrayList<PlacementDecisionBuilder>();
  private String placement;
  private String placementBinding;
  private String placementRule;
  
  protected void copyInstance(Placement instance) {
    instance = (instance != null ? instance : new Placement());
  
    if (instance != null) {
        this.withDecisions(instance.getDecisions());
        this.withPlacement(instance.getPlacement());
        this.withPlacementBinding(instance.getPlacementBinding());
        this.withPlacementRule(instance.getPlacementRule());
        this.withDecisions(instance.getDecisions());
        this.withPlacement(instance.getPlacement());
        this.withPlacementBinding(instance.getPlacementBinding());
        this.withPlacementRule(instance.getPlacementRule());
      }
  }
  
  public A addToDecisions(int index,PlacementDecision item) {
    if (this.decisions == null) {this.decisions = new ArrayList<PlacementDecisionBuilder>();}
    PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);
    if (index < 0 || index >= decisions.size()) { _visitables.get("decisions").add(builder); decisions.add(builder); } else { _visitables.get("decisions").add(index, builder); decisions.add(index, builder);}
    return (A)this;
  }
  
  public A setToDecisions(int index,PlacementDecision item) {
    if (this.decisions == null) {this.decisions = new ArrayList<PlacementDecisionBuilder>();}
    PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);
    if (index < 0 || index >= decisions.size()) { _visitables.get("decisions").add(builder); decisions.add(builder); } else { _visitables.get("decisions").set(index, builder); decisions.set(index, builder);}
    return (A)this;
  }
  
  public A addToDecisions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecision... items) {
    if (this.decisions == null) {this.decisions = new ArrayList<PlacementDecisionBuilder>();}
    for (PlacementDecision item : items) {PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);_visitables.get("decisions").add(builder);this.decisions.add(builder);} return (A)this;
  }
  
  public A addAllToDecisions(Collection<PlacementDecision> items) {
    if (this.decisions == null) {this.decisions = new ArrayList<PlacementDecisionBuilder>();}
    for (PlacementDecision item : items) {PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);_visitables.get("decisions").add(builder);this.decisions.add(builder);} return (A)this;
  }
  
  public A removeFromDecisions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecision... items) {
    if (this.decisions == null) return (A)this;
    for (PlacementDecision item : items) {PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);_visitables.get("decisions").remove(builder); this.decisions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDecisions(Collection<PlacementDecision> items) {
    if (this.decisions == null) return (A)this;
    for (PlacementDecision item : items) {PlacementDecisionBuilder builder = new PlacementDecisionBuilder(item);_visitables.get("decisions").remove(builder); this.decisions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDecisions(Predicate<PlacementDecisionBuilder> predicate) {
    if (decisions == null) return (A) this;
    final Iterator<PlacementDecisionBuilder> each = decisions.iterator();
    final List visitables = _visitables.get("decisions");
    while (each.hasNext()) {
      PlacementDecisionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PlacementDecision> buildDecisions() {
    return decisions != null ? build(decisions) : null;
  }
  
  public PlacementDecision buildDecision(int index) {
    return this.decisions.get(index).build();
  }
  
  public PlacementDecision buildFirstDecision() {
    return this.decisions.get(0).build();
  }
  
  public PlacementDecision buildLastDecision() {
    return this.decisions.get(decisions.size() - 1).build();
  }
  
  public PlacementDecision buildMatchingDecision(Predicate<PlacementDecisionBuilder> predicate) {
    for (PlacementDecisionBuilder item: decisions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingDecision(Predicate<PlacementDecisionBuilder> predicate) {
    for (PlacementDecisionBuilder item: decisions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withDecisions(List<PlacementDecision> decisions) {
    if (this.decisions != null) { _visitables.get("decisions").clear();}
    if (decisions != null) {this.decisions = new ArrayList(); for (PlacementDecision item : decisions){this.addToDecisions(item);}} else { this.decisions = null;} return (A) this;
  }
  
  public A withDecisions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.PlacementDecision... decisions) {
    if (this.decisions != null) {this.decisions.clear(); _visitables.remove("decisions"); }
    if (decisions != null) {for (PlacementDecision item :decisions){ this.addToDecisions(item);}} return (A) this;
  }
  
  public boolean hasDecisions() {
    return decisions != null && !decisions.isEmpty();
  }
  
  public A addNewDecision(String clusterName,String clusterNamespace) {
    return (A)addToDecisions(new PlacementDecision(clusterName, clusterNamespace));
  }
  
  public DecisionsNested<A> addNewDecision() {
    return new DecisionsNested(-1, null);
  }
  
  public DecisionsNested<A> addNewDecisionLike(PlacementDecision item) {
    return new DecisionsNested(-1, item);
  }
  
  public DecisionsNested<A> setNewDecisionLike(int index,PlacementDecision item) {
    return new DecisionsNested(index, item);
  }
  
  public DecisionsNested<A> editDecision(int index) {
    if (decisions.size() <= index) throw new RuntimeException("Can't edit decisions. Index exceeds size.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  
  public DecisionsNested<A> editFirstDecision() {
    if (decisions.size() == 0) throw new RuntimeException("Can't edit first decisions. The list is empty.");
    return setNewDecisionLike(0, buildDecision(0));
  }
  
  public DecisionsNested<A> editLastDecision() {
    int index = decisions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last decisions. The list is empty.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  
  public DecisionsNested<A> editMatchingDecision(Predicate<PlacementDecisionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<decisions.size();i++) { 
    if (predicate.test(decisions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching decisions. No match found.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  
  public String getPlacement() {
    return this.placement;
  }
  
  public A withPlacement(String placement) {
    this.placement=placement; return (A) this;
  }
  
  public boolean hasPlacement() {
    return this.placement != null;
  }
  
  public String getPlacementBinding() {
    return this.placementBinding;
  }
  
  public A withPlacementBinding(String placementBinding) {
    this.placementBinding=placementBinding; return (A) this;
  }
  
  public boolean hasPlacementBinding() {
    return this.placementBinding != null;
  }
  
  public String getPlacementRule() {
    return this.placementRule;
  }
  
  public A withPlacementRule(String placementRule) {
    this.placementRule=placementRule; return (A) this;
  }
  
  public boolean hasPlacementRule() {
    return this.placementRule != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementFluent that = (PlacementFluent) o;
    if (!java.util.Objects.equals(decisions, that.decisions)) return false;
  
    if (!java.util.Objects.equals(placement, that.placement)) return false;
  
    if (!java.util.Objects.equals(placementBinding, that.placementBinding)) return false;
  
    if (!java.util.Objects.equals(placementRule, that.placementRule)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(decisions,  placement,  placementBinding,  placementRule,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (decisions != null && !decisions.isEmpty()) { sb.append("decisions:"); sb.append(decisions + ","); }
    if (placement != null) { sb.append("placement:"); sb.append(placement + ","); }
    if (placementBinding != null) { sb.append("placementBinding:"); sb.append(placementBinding + ","); }
    if (placementRule != null) { sb.append("placementRule:"); sb.append(placementRule); }
    sb.append("}");
    return sb.toString();
  }
  public class DecisionsNested<N> extends PlacementDecisionFluent<DecisionsNested<N>> implements Nested<N>{
    DecisionsNested(int index,PlacementDecision item) {
      this.index = index;
      this.builder = new PlacementDecisionBuilder(this, item);
    }
    PlacementDecisionBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementFluent.this.setToDecisions(index,builder.build());
    }
    
    public N endDecision() {
      return and();
    }
    
  
  }

}