package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PlacementBuilder extends PlacementFluent<PlacementBuilder> implements VisitableBuilder<Placement,PlacementBuilder>{
  public PlacementBuilder() {
    this(new Placement());
  }
  
  public PlacementBuilder(PlacementFluent<?> fluent) {
    this(fluent, new Placement());
  }
  
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PlacementBuilder(Placement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PlacementFluent<?> fluent;
  
  public Placement build() {
    Placement buildable = new Placement(fluent.buildDecisions(),fluent.getPlacement(),fluent.getPlacementBinding(),fluent.getPlacementRule());
    return buildable;
  }
  

}