package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyAutomationBuilder extends PolicyAutomationFluent<PolicyAutomationBuilder> implements VisitableBuilder<PolicyAutomation,PolicyAutomationBuilder>{
  public PolicyAutomationBuilder() {
    this(false);
  }
  public PolicyAutomationBuilder(Boolean validationEnabled) {
    this(new PolicyAutomation(), validationEnabled);
  }
  public PolicyAutomationBuilder(PolicyAutomationFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyAutomationBuilder(PolicyAutomationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyAutomation(), validationEnabled);
  }
  public PolicyAutomationBuilder(PolicyAutomationFluent<?> fluent,PolicyAutomation instance) {
    this(fluent, instance, false);
  }
  public PolicyAutomationBuilder(PolicyAutomationFluent<?> fluent,PolicyAutomation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PolicyAutomation());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicyAutomationBuilder(PolicyAutomation instance) {
    this(instance,false);
  }
  public PolicyAutomationBuilder(PolicyAutomation instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PolicyAutomation());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicyAutomationFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyAutomation build() {
    PolicyAutomation buildable = new PolicyAutomation(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}