package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectBuilder extends SubjectFluent<SubjectBuilder> implements VisitableBuilder<Subject,SubjectBuilder>{
  public SubjectBuilder() {
    this(false);
  }
  public SubjectBuilder(Boolean validationEnabled) {
    this(new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance) {
    this(fluent, instance, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Subject());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectBuilder(Subject instance) {
    this(instance,false);
  }
  public SubjectBuilder(Subject instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Subject());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectFluent<?> fluent;
  Boolean validationEnabled;
  public Subject build() {
    Subject buildable = new Subject(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    return buildable;
  }
  
}