package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyStatusBuilder extends PolicyStatusFluent<PolicyStatusBuilder> implements VisitableBuilder<PolicyStatus,PolicyStatusBuilder>{
  public PolicyStatusBuilder() {
    this(false);
  }
  public PolicyStatusBuilder(Boolean validationEnabled) {
    this(new PolicyStatus(), validationEnabled);
  }
  public PolicyStatusBuilder(PolicyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyStatusBuilder(PolicyStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyStatus(), validationEnabled);
  }
  public PolicyStatusBuilder(PolicyStatusFluent<?> fluent,PolicyStatus instance) {
    this(fluent, instance, false);
  }
  public PolicyStatusBuilder(PolicyStatusFluent<?> fluent,PolicyStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PolicyStatus());

    if (instance != null) {
      fluent.withCompliant(instance.getCompliant());
      fluent.withDetails(instance.getDetails());
      fluent.withPlacement(instance.getPlacement());
      fluent.withStatus(instance.getStatus());
      fluent.withCompliant(instance.getCompliant());
      fluent.withDetails(instance.getDetails());
      fluent.withPlacement(instance.getPlacement());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicyStatusBuilder(PolicyStatus instance) {
    this(instance,false);
  }
  public PolicyStatusBuilder(PolicyStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PolicyStatus());

    if (instance != null) {
      this.withCompliant(instance.getCompliant());
      this.withDetails(instance.getDetails());
      this.withPlacement(instance.getPlacement());
      this.withStatus(instance.getStatus());
      this.withCompliant(instance.getCompliant());
      this.withDetails(instance.getDetails());
      this.withPlacement(instance.getPlacement());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicyStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyStatus build() {
    PolicyStatus buildable = new PolicyStatus(fluent.getCompliant(),fluent.buildDetails(),fluent.buildPlacement(),fluent.buildStatus());
    return buildable;
  }
  
}