package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicySpecBuilder extends PolicySpecFluent<PolicySpecBuilder> implements VisitableBuilder<PolicySpec,PolicySpecBuilder>{
  public PolicySpecBuilder() {
    this(false);
  }
  public PolicySpecBuilder(Boolean validationEnabled) {
    this(new PolicySpec(), validationEnabled);
  }
  public PolicySpecBuilder(PolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicySpecBuilder(PolicySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicySpec(), validationEnabled);
  }
  public PolicySpecBuilder(PolicySpecFluent<?> fluent,PolicySpec instance) {
    this(fluent, instance, false);
  }
  public PolicySpecBuilder(PolicySpecFluent<?> fluent,PolicySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PolicySpec());

    if (instance != null) {
      fluent.withDisabled(instance.getDisabled());
      fluent.withPolicyTemplates(instance.getPolicyTemplates());
      fluent.withRemediationAction(instance.getRemediationAction());
      fluent.withDisabled(instance.getDisabled());
      fluent.withPolicyTemplates(instance.getPolicyTemplates());
      fluent.withRemediationAction(instance.getRemediationAction());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicySpecBuilder(PolicySpec instance) {
    this(instance,false);
  }
  public PolicySpecBuilder(PolicySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PolicySpec());

    if (instance != null) {
      this.withDisabled(instance.getDisabled());
      this.withPolicyTemplates(instance.getPolicyTemplates());
      this.withRemediationAction(instance.getRemediationAction());
      this.withDisabled(instance.getDisabled());
      this.withPolicyTemplates(instance.getPolicyTemplates());
      this.withRemediationAction(instance.getRemediationAction());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicySpecFluent<?> fluent;
  Boolean validationEnabled;
  public PolicySpec build() {
    PolicySpec buildable = new PolicySpec(fluent.getDisabled(),fluent.buildPolicyTemplates(),fluent.getRemediationAction());
    return buildable;
  }
  
}