package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyListBuilder extends PolicyListFluent<PolicyListBuilder> implements VisitableBuilder<PolicyList,PolicyListBuilder>{
  public PolicyListBuilder() {
    this(false);
  }
  public PolicyListBuilder(Boolean validationEnabled) {
    this(new PolicyList(), validationEnabled);
  }
  public PolicyListBuilder(PolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyListBuilder(PolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyList(), validationEnabled);
  }
  public PolicyListBuilder(PolicyListFluent<?> fluent,PolicyList instance) {
    this(fluent, instance, false);
  }
  public PolicyListBuilder(PolicyListFluent<?> fluent,PolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PolicyList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicyListBuilder(PolicyList instance) {
    this(instance,false);
  }
  public PolicyListBuilder(PolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PolicyList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyList build() {
    PolicyList buildable = new PolicyList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}