package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementSubjectBuilder extends PlacementSubjectFluent<PlacementSubjectBuilder> implements VisitableBuilder<PlacementSubject,PlacementSubjectBuilder>{
  public PlacementSubjectBuilder() {
    this(false);
  }
  public PlacementSubjectBuilder(Boolean validationEnabled) {
    this(new PlacementSubject(), validationEnabled);
  }
  public PlacementSubjectBuilder(PlacementSubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementSubjectBuilder(PlacementSubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementSubject(), validationEnabled);
  }
  public PlacementSubjectBuilder(PlacementSubjectFluent<?> fluent,PlacementSubject instance) {
    this(fluent, instance, false);
  }
  public PlacementSubjectBuilder(PlacementSubjectFluent<?> fluent,PlacementSubject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlacementSubject());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementSubjectBuilder(PlacementSubject instance) {
    this(instance,false);
  }
  public PlacementSubjectBuilder(PlacementSubject instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlacementSubject());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementSubjectFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementSubject build() {
    PlacementSubject buildable = new PlacementSubject(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    return buildable;
  }
  
}