package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DetailsPerTemplateFluent<A extends DetailsPerTemplateFluent<A>> extends BaseFluent<A>{
  public DetailsPerTemplateFluent() {
  }
  public DetailsPerTemplateFluent(DetailsPerTemplate instance) {
    instance = (instance != null ? instance : new DetailsPerTemplate());

    if (instance != null) {
      this.withCompliant(instance.getCompliant());
      this.withHistory(instance.getHistory());
      this.withTemplateMeta(instance.getTemplateMeta());
      this.withCompliant(instance.getCompliant());
      this.withHistory(instance.getHistory());
      this.withTemplateMeta(instance.getTemplateMeta());
    }
  }
  private String compliant;
  private ArrayList<ComplianceHistoryBuilder> history = new ArrayList<ComplianceHistoryBuilder>();
  private ObjectMetaBuilder templateMeta;
  public String getCompliant() {
    return this.compliant;
  }
  public A withCompliant(String compliant) {
    this.compliant=compliant; return (A) this;
  }
  public boolean hasCompliant() {
    return this.compliant != null;
  }
  public A addToHistory(int index,ComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").add(index, builder); history.add(index, builder);}
    return (A)this;
  }
  public A setToHistory(int index,ComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").set(index, builder); history.set(index, builder);}
    return (A)this;
  }
  public A addToHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... items) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A addAllToHistory(Collection<ComplianceHistory> items) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A removeFromHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... items) {
    if (this.history == null) return (A)this;
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  public A removeAllFromHistory(Collection<ComplianceHistory> items) {
    if (this.history == null) return (A)this;
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").remove(builder); this.history.remove(builder);} return (A)this;
  }
  public A removeMatchingFromHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    if (history == null) return (A) this;
    final Iterator<ComplianceHistoryBuilder> each = history.iterator();
    final List visitables = _visitables.get("history");
    while (each.hasNext()) {
      ComplianceHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ComplianceHistory> buildHistory() {
    return history != null ? build(history) : null;
  }
  public ComplianceHistory buildHistory(int index) {
    return this.history.get(index).build();
  }
  public ComplianceHistory buildFirstHistory() {
    return this.history.get(0).build();
  }
  public ComplianceHistory buildLastHistory() {
    return this.history.get(history.size() - 1).build();
  }
  public ComplianceHistory buildMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    for (ComplianceHistoryBuilder item: history) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    for (ComplianceHistoryBuilder item: history) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHistory(List<ComplianceHistory> history) {
    if (this.history != null) { _visitables.get("history").clear();}
    if (history != null) {this.history = new ArrayList(); for (ComplianceHistory item : history){this.addToHistory(item);}} else { this.history = null;} return (A) this;
  }
  public A withHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... history) {
    if (this.history != null) {this.history.clear(); _visitables.remove("history"); }
    if (history != null) {for (ComplianceHistory item :history){ this.addToHistory(item);}} return (A) this;
  }
  public boolean hasHistory() {
    return history != null && !history.isEmpty();
  }
  public A addNewHistory(String eventName,String lastTimestamp,String message) {
    return (A)addToHistory(new ComplianceHistory(eventName, lastTimestamp, message));
  }
  public HistoryNested<A> addNewHistory() {
    return new HistoryNested(-1, null);
  }
  public HistoryNested<A> addNewHistoryLike(ComplianceHistory item) {
    return new HistoryNested(-1, item);
  }
  public HistoryNested<A> setNewHistoryLike(int index,ComplianceHistory item) {
    return new HistoryNested(index, item);
  }
  public HistoryNested<A> editHistory(int index) {
    if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public HistoryNested<A> editFirstHistory() {
    if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
    return setNewHistoryLike(0, buildHistory(0));
  }
  public HistoryNested<A> editLastHistory() {
    int index = history.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public HistoryNested<A> editMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<history.size();i++) { 
    if (predicate.test(history.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public ObjectMeta buildTemplateMeta() {
    return this.templateMeta!=null ?this.templateMeta.build():null;
  }
  public A withTemplateMeta(ObjectMeta templateMeta) {
    _visitables.get("templateMeta").remove(this.templateMeta);
    if (templateMeta!=null){ this.templateMeta= new ObjectMetaBuilder(templateMeta); _visitables.get("templateMeta").add(this.templateMeta);} else { this.templateMeta = null; _visitables.get("templateMeta").remove(this.templateMeta); } return (A) this;
  }
  public boolean hasTemplateMeta() {
    return this.templateMeta != null;
  }
  public TemplateMetaNested<A> withNewTemplateMeta() {
    return new TemplateMetaNested(null);
  }
  public TemplateMetaNested<A> withNewTemplateMetaLike(ObjectMeta item) {
    return new TemplateMetaNested(item);
  }
  public TemplateMetaNested<A> editTemplateMeta() {
    return withNewTemplateMetaLike(java.util.Optional.ofNullable(buildTemplateMeta()).orElse(null));
  }
  public TemplateMetaNested<A> editOrNewTemplateMeta() {
    return withNewTemplateMetaLike(java.util.Optional.ofNullable(buildTemplateMeta()).orElse(new ObjectMetaBuilder().build()));
  }
  public TemplateMetaNested<A> editOrNewTemplateMetaLike(ObjectMeta item) {
    return withNewTemplateMetaLike(java.util.Optional.ofNullable(buildTemplateMeta()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DetailsPerTemplateFluent that = (DetailsPerTemplateFluent) o;
    if (!java.util.Objects.equals(compliant, that.compliant)) return false;

    if (!java.util.Objects.equals(history, that.history)) return false;

    if (!java.util.Objects.equals(templateMeta, that.templateMeta)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(compliant,  history,  templateMeta,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (compliant != null) { sb.append("compliant:"); sb.append(compliant + ","); }
    if (history != null && !history.isEmpty()) { sb.append("history:"); sb.append(history + ","); }
    if (templateMeta != null) { sb.append("templateMeta:"); sb.append(templateMeta); }
    sb.append("}");
    return sb.toString();
  }
  public class HistoryNested<N> extends ComplianceHistoryFluent<HistoryNested<N>> implements Nested<N>{
    HistoryNested(int index,ComplianceHistory item) {
      this.index = index;
      this.builder = new ComplianceHistoryBuilder(this, item);
    }
    ComplianceHistoryBuilder builder;
    int index;
    public N and() {
      return (N) DetailsPerTemplateFluent.this.setToHistory(index,builder.build());
    }
    public N endHistory() {
      return and();
    }
    
  }
  public class TemplateMetaNested<N> extends ObjectMetaFluent<TemplateMetaNested<N>> implements Nested<N>{
    TemplateMetaNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) DetailsPerTemplateFluent.this.withTemplateMeta(builder.build());
    }
    public N endTemplateMeta() {
      return and();
    }
    
  }
  
}