package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComplianceHistoryBuilder extends ComplianceHistoryFluent<ComplianceHistoryBuilder> implements VisitableBuilder<ComplianceHistory,ComplianceHistoryBuilder>{
  public ComplianceHistoryBuilder() {
    this(false);
  }
  public ComplianceHistoryBuilder(Boolean validationEnabled) {
    this(new ComplianceHistory(), validationEnabled);
  }
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent) {
    this(fluent, false);
  }
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComplianceHistory(), validationEnabled);
  }
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent,ComplianceHistory instance) {
    this(fluent, instance, false);
  }
  public ComplianceHistoryBuilder(ComplianceHistoryFluent<?> fluent,ComplianceHistory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ComplianceHistory());

    if (instance != null) {
      fluent.withEventName(instance.getEventName());
      fluent.withLastTimestamp(instance.getLastTimestamp());
      fluent.withMessage(instance.getMessage());
      fluent.withEventName(instance.getEventName());
      fluent.withLastTimestamp(instance.getLastTimestamp());
      fluent.withMessage(instance.getMessage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComplianceHistoryBuilder(ComplianceHistory instance) {
    this(instance,false);
  }
  public ComplianceHistoryBuilder(ComplianceHistory instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ComplianceHistory());

    if (instance != null) {
      this.withEventName(instance.getEventName());
      this.withLastTimestamp(instance.getLastTimestamp());
      this.withMessage(instance.getMessage());
      this.withEventName(instance.getEventName());
      this.withLastTimestamp(instance.getLastTimestamp());
      this.withMessage(instance.getMessage());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComplianceHistoryFluent<?> fluent;
  Boolean validationEnabled;
  public ComplianceHistory build() {
    ComplianceHistory buildable = new ComplianceHistory(fluent.getEventName(),fluent.getLastTimestamp(),fluent.getMessage());
    return buildable;
  }
  
}