package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementDecisionBuilder extends PlacementDecisionFluentImpl<PlacementDecisionBuilder> implements VisitableBuilder<PlacementDecision,PlacementDecisionBuilder>{
  public PlacementDecisionBuilder() {
    this(false);
  }
  public PlacementDecisionBuilder(Boolean validationEnabled) {
    this(new PlacementDecision(), validationEnabled);
  }
  public PlacementDecisionBuilder(PlacementDecisionFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementDecisionBuilder(PlacementDecisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementDecision(), validationEnabled);
  }
  public PlacementDecisionBuilder(PlacementDecisionFluent<?> fluent,PlacementDecision instance) {
    this(fluent, instance, false);
  }
  public PlacementDecisionBuilder(PlacementDecisionFluent<?> fluent,PlacementDecision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterName(instance.getClusterName()); 
    fluent.withClusterNamespace(instance.getClusterNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementDecisionBuilder(PlacementDecision instance) {
    this(instance,false);
  }
  public PlacementDecisionBuilder(PlacementDecision instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterName(instance.getClusterName()); 
    this.withClusterNamespace(instance.getClusterNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementDecisionFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementDecision build() {
    PlacementDecision buildable = new PlacementDecision(fluent.getClusterName(),fluent.getClusterNamespace());
    return buildable;
  }
  
}