package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementBindingListBuilder extends PlacementBindingListFluentImpl<PlacementBindingListBuilder> implements VisitableBuilder<PlacementBindingList,PlacementBindingListBuilder>{
  public PlacementBindingListBuilder() {
    this(false);
  }
  public PlacementBindingListBuilder(Boolean validationEnabled) {
    this(new PlacementBindingList(), validationEnabled);
  }
  public PlacementBindingListBuilder(PlacementBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementBindingListBuilder(PlacementBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementBindingList(), validationEnabled);
  }
  public PlacementBindingListBuilder(PlacementBindingListFluent<?> fluent,PlacementBindingList instance) {
    this(fluent, instance, false);
  }
  public PlacementBindingListBuilder(PlacementBindingListFluent<?> fluent,PlacementBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementBindingListBuilder(PlacementBindingList instance) {
    this(instance,false);
  }
  public PlacementBindingListBuilder(PlacementBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementBindingList build() {
    PlacementBindingList buildable = new PlacementBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}