/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatus;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatusBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.CompliancePerClusterStatusFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplateBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplateFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Placement;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyStatusFluent<A extends PolicyStatusFluent<A>>
extends BaseFluent<A> {
    private String compliant;
    private ArrayList<DetailsPerTemplateBuilder> details = new ArrayList();
    private ArrayList<PlacementBuilder> placement = new ArrayList();
    private ArrayList<CompliancePerClusterStatusBuilder> status = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PolicyStatusFluent() {
    }

    public PolicyStatusFluent(PolicyStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicyStatus instance) {
        PolicyStatus policyStatus = instance = instance != null ? instance : new PolicyStatus();
        if (instance != null) {
            this.withCompliant(instance.getCompliant());
            this.withDetails(instance.getDetails());
            this.withPlacement(instance.getPlacement());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCompliant() {
        return this.compliant;
    }

    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)((Object)this);
    }

    public boolean hasCompliant() {
        return this.compliant != null;
    }

    public A addToDetails(int index, DetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").add(index, builder);
            this.details.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDetails(int index, DetailsPerTemplate item) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
        if (index < 0 || index >= this.details.size()) {
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        } else {
            this._visitables.get((Object)"details").set(index, builder);
            this.details.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDetails(DetailsPerTemplate ... items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDetails(Collection<DetailsPerTemplate> items) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").add(builder);
            this.details.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDetails(DetailsPerTemplate ... items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDetails(Collection<DetailsPerTemplate> items) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        for (DetailsPerTemplate item : items) {
            DetailsPerTemplateBuilder builder = new DetailsPerTemplateBuilder(item);
            this._visitables.get((Object)"details").remove((Object)builder);
            this.details.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDetails(Predicate<DetailsPerTemplateBuilder> predicate) {
        if (this.details == null) {
            return (A)((Object)this);
        }
        Iterator<DetailsPerTemplateBuilder> each = this.details.iterator();
        List visitables = this._visitables.get((Object)"details");
        while (each.hasNext()) {
            DetailsPerTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DetailsPerTemplate> buildDetails() {
        return this.details != null ? PolicyStatusFluent.build(this.details) : null;
    }

    public DetailsPerTemplate buildDetail(int index) {
        return this.details.get(index).build();
    }

    public DetailsPerTemplate buildFirstDetail() {
        return this.details.get(0).build();
    }

    public DetailsPerTemplate buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    public DetailsPerTemplate buildMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        for (DetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        for (DetailsPerTemplateBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDetails(List<DetailsPerTemplate> details) {
        if (this.details != null) {
            this._visitables.get((Object)"details").clear();
        }
        if (details != null) {
            this.details = new ArrayList();
            for (DetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)((Object)this);
    }

    public A withDetails(DetailsPerTemplate ... details) {
        if (this.details != null) {
            this.details.clear();
            this._visitables.remove((Object)"details");
        }
        if (details != null) {
            for (DetailsPerTemplate item : details) {
                this.addToDetails(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public DetailsNested<A> addNewDetail() {
        return new DetailsNested(-1, null);
    }

    public DetailsNested<A> addNewDetailLike(DetailsPerTemplate item) {
        return new DetailsNested(-1, item);
    }

    public DetailsNested<A> setNewDetailLike(int index, DetailsPerTemplate item) {
        return new DetailsNested(index, item);
    }

    public DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    public DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public DetailsNested<A> editMatchingDetail(Predicate<DetailsPerTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    public A addToPlacement(int index, Placement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").add(index, builder);
            this.placement.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPlacement(int index, Placement item) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placement.size()) {
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        } else {
            this._visitables.get((Object)"placement").set(index, builder);
            this.placement.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPlacement(Placement ... items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPlacement(Collection<Placement> items) {
        if (this.placement == null) {
            this.placement = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").add(builder);
            this.placement.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPlacement(Placement ... items) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").remove((Object)builder);
            this.placement.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlacement(Collection<Placement> items) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placement").remove((Object)builder);
            this.placement.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPlacement(Predicate<PlacementBuilder> predicate) {
        if (this.placement == null) {
            return (A)((Object)this);
        }
        Iterator<PlacementBuilder> each = this.placement.iterator();
        List visitables = this._visitables.get((Object)"placement");
        while (each.hasNext()) {
            PlacementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Placement> buildPlacement() {
        return this.placement != null ? PolicyStatusFluent.build(this.placement) : null;
    }

    public Placement buildPlacement(int index) {
        return this.placement.get(index).build();
    }

    public Placement buildFirstPlacement() {
        return this.placement.get(0).build();
    }

    public Placement buildLastPlacement() {
        return this.placement.get(this.placement.size() - 1).build();
    }

    public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placement) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlacement(List<Placement> placement) {
        if (this.placement != null) {
            this._visitables.get((Object)"placement").clear();
        }
        if (placement != null) {
            this.placement = new ArrayList();
            for (Placement item : placement) {
                this.addToPlacement(item);
            }
        } else {
            this.placement = null;
        }
        return (A)((Object)this);
    }

    public A withPlacement(Placement ... placement) {
        if (this.placement != null) {
            this.placement.clear();
            this._visitables.remove((Object)"placement");
        }
        if (placement != null) {
            for (Placement item : placement) {
                this.addToPlacement(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlacement() {
        return this.placement != null && !this.placement.isEmpty();
    }

    public PlacementNested<A> addNewPlacement() {
        return new PlacementNested(-1, null);
    }

    public PlacementNested<A> addNewPlacementLike(Placement item) {
        return new PlacementNested(-1, item);
    }

    public PlacementNested<A> setNewPlacementLike(int index, Placement item) {
        return new PlacementNested(index, item);
    }

    public PlacementNested<A> editPlacement(int index) {
        if (this.placement.size() <= index) {
            throw new RuntimeException("Can't edit placement. Index exceeds size.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementNested<A> editFirstPlacement() {
        if (this.placement.size() == 0) {
            throw new RuntimeException("Can't edit first placement. The list is empty.");
        }
        return this.setNewPlacementLike(0, this.buildPlacement(0));
    }

    public PlacementNested<A> editLastPlacement() {
        int index = this.placement.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last placement. The list is empty.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.placement.size(); ++i) {
            if (!predicate.test(this.placement.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching placement. No match found.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public A addToStatus(int index, CompliancePerClusterStatus item) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
        if (index < 0 || index >= this.status.size()) {
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        } else {
            this._visitables.get((Object)"status").add(index, builder);
            this.status.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStatus(int index, CompliancePerClusterStatus item) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
        if (index < 0 || index >= this.status.size()) {
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        } else {
            this._visitables.get((Object)"status").set(index, builder);
            this.status.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStatus(CompliancePerClusterStatus ... items) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStatus(Collection<CompliancePerClusterStatus> items) {
        if (this.status == null) {
            this.status = new ArrayList();
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").add(builder);
            this.status.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStatus(CompliancePerClusterStatus ... items) {
        if (this.status == null) {
            return (A)((Object)this);
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").remove((Object)builder);
            this.status.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStatus(Collection<CompliancePerClusterStatus> items) {
        if (this.status == null) {
            return (A)((Object)this);
        }
        for (CompliancePerClusterStatus item : items) {
            CompliancePerClusterStatusBuilder builder = new CompliancePerClusterStatusBuilder(item);
            this._visitables.get((Object)"status").remove((Object)builder);
            this.status.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        if (this.status == null) {
            return (A)((Object)this);
        }
        Iterator<CompliancePerClusterStatusBuilder> each = this.status.iterator();
        List visitables = this._visitables.get((Object)"status");
        while (each.hasNext()) {
            CompliancePerClusterStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CompliancePerClusterStatus> buildStatus() {
        return this.status != null ? PolicyStatusFluent.build(this.status) : null;
    }

    public CompliancePerClusterStatus buildStatus(int index) {
        return this.status.get(index).build();
    }

    public CompliancePerClusterStatus buildFirstStatus() {
        return this.status.get(0).build();
    }

    public CompliancePerClusterStatus buildLastStatus() {
        return this.status.get(this.status.size() - 1).build();
    }

    public CompliancePerClusterStatus buildMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        for (CompliancePerClusterStatusBuilder item : this.status) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        for (CompliancePerClusterStatusBuilder item : this.status) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStatus(List<CompliancePerClusterStatus> status) {
        if (this.status != null) {
            this._visitables.get((Object)"status").clear();
        }
        if (status != null) {
            this.status = new ArrayList();
            for (CompliancePerClusterStatus item : status) {
                this.addToStatus(item);
            }
        } else {
            this.status = null;
        }
        return (A)((Object)this);
    }

    public A withStatus(CompliancePerClusterStatus ... status) {
        if (this.status != null) {
            this.status.clear();
            this._visitables.remove((Object)"status");
        }
        if (status != null) {
            for (CompliancePerClusterStatus item : status) {
                this.addToStatus(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public A addNewStatus(String clustername, String clusternamespace, String compliant) {
        return this.addToStatus(new CompliancePerClusterStatus(clustername, clusternamespace, compliant));
    }

    public StatusNested<A> addNewStatus() {
        return new StatusNested(-1, null);
    }

    public StatusNested<A> addNewStatusLike(CompliancePerClusterStatus item) {
        return new StatusNested(-1, item);
    }

    public StatusNested<A> setNewStatusLike(int index, CompliancePerClusterStatus item) {
        return new StatusNested(index, item);
    }

    public StatusNested<A> editStatus(int index) {
        if (this.status.size() <= index) {
            throw new RuntimeException("Can't edit status. Index exceeds size.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    public StatusNested<A> editFirstStatus() {
        if (this.status.size() == 0) {
            throw new RuntimeException("Can't edit first status. The list is empty.");
        }
        return this.setNewStatusLike(0, this.buildStatus(0));
    }

    public StatusNested<A> editLastStatus() {
        int index = this.status.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last status. The list is empty.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    public StatusNested<A> editMatchingStatus(Predicate<CompliancePerClusterStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.status.size(); ++i) {
            if (!predicate.test(this.status.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching status. No match found.");
        }
        return this.setNewStatusLike(index, this.buildStatus(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyStatusFluent that = (PolicyStatusFluent)((Object)o);
        if (!Objects.equals(this.compliant, that.compliant)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.placement, that.placement)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.details, this.placement, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.details != null && !this.details.isEmpty()) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.placement != null && !this.placement.isEmpty()) {
            sb.append("placement:");
            sb.append(this.placement + ",");
        }
        if (this.status != null && !this.status.isEmpty()) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StatusNested<N>
    extends CompliancePerClusterStatusFluent<StatusNested<N>>
    implements Nested<N> {
        CompliancePerClusterStatusBuilder builder;
        int index;

        StatusNested(int index, CompliancePerClusterStatus item) {
            this.index = index;
            this.builder = new CompliancePerClusterStatusBuilder(this, item);
        }

        public N and() {
            return (N)PolicyStatusFluent.this.setToStatus(this.index, this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class PlacementNested<N>
    extends PlacementFluent<PlacementNested<N>>
    implements Nested<N> {
        PlacementBuilder builder;
        int index;

        PlacementNested(int index, Placement item) {
            this.index = index;
            this.builder = new PlacementBuilder(this, item);
        }

        public N and() {
            return (N)PolicyStatusFluent.this.setToPlacement(this.index, this.builder.build());
        }

        public N endPlacement() {
            return this.and();
        }
    }

    public class DetailsNested<N>
    extends DetailsPerTemplateFluent<DetailsNested<N>>
    implements Nested<N> {
        DetailsPerTemplateBuilder builder;
        int index;

        DetailsNested(int index, DetailsPerTemplate item) {
            this.index = index;
            this.builder = new DetailsPerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)PolicyStatusFluent.this.setToDetails(this.index, this.builder.build());
        }

        public N endDetail() {
            return this.and();
        }
    }
}

