package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PolicySpecFluent<A extends PolicySpecFluent<A>> extends BaseFluent<A>{
  public PolicySpecFluent() {
  }
  
  public PolicySpecFluent(PolicySpec instance) {
    this.copyInstance(instance);
  }
  private Boolean disabled;
  private ArrayList<PolicyTemplateBuilder> policyTemplates = new ArrayList<PolicyTemplateBuilder>();
  private String remediationAction;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PolicySpec instance) {
    instance = (instance != null ? instance : new PolicySpec());
    if (instance != null) {
          this.withDisabled(instance.getDisabled());
          this.withPolicyTemplates(instance.getPolicyTemplates());
          this.withRemediationAction(instance.getRemediationAction());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getDisabled() {
    return this.disabled;
  }
  
  public A withDisabled(Boolean disabled) {
    this.disabled = disabled;
    return (A) this;
  }
  
  public boolean hasDisabled() {
    return this.disabled != null;
  }
  
  public A addToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").add(index, builder); policyTemplates.add(index, builder);}
    return (A)this;
  }
  
  public A setToPolicyTemplates(int index,PolicyTemplate item) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);
    if (index < 0 || index >= policyTemplates.size()) { _visitables.get("policyTemplates").add(builder); policyTemplates.add(builder); } else { _visitables.get("policyTemplates").set(index, builder); policyTemplates.set(index, builder);}
    return (A)this;
  }
  
  public A addToPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  
  public A addAllToPolicyTemplates(Collection<PolicyTemplate> items) {
    if (this.policyTemplates == null) {this.policyTemplates = new ArrayList<PolicyTemplateBuilder>();}
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").add(builder);this.policyTemplates.add(builder);} return (A)this;
  }
  
  public A removeFromPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... items) {
    if (this.policyTemplates == null) return (A)this;
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder); this.policyTemplates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPolicyTemplates(Collection<PolicyTemplate> items) {
    if (this.policyTemplates == null) return (A)this;
    for (PolicyTemplate item : items) {PolicyTemplateBuilder builder = new PolicyTemplateBuilder(item);_visitables.get("policyTemplates").remove(builder); this.policyTemplates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPolicyTemplates(Predicate<PolicyTemplateBuilder> predicate) {
    if (policyTemplates == null) return (A) this;
    final Iterator<PolicyTemplateBuilder> each = policyTemplates.iterator();
    final List visitables = _visitables.get("policyTemplates");
    while (each.hasNext()) {
      PolicyTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PolicyTemplate> buildPolicyTemplates() {
    return this.policyTemplates != null ? build(policyTemplates) : null;
  }
  
  public PolicyTemplate buildPolicyTemplate(int index) {
    return this.policyTemplates.get(index).build();
  }
  
  public PolicyTemplate buildFirstPolicyTemplate() {
    return this.policyTemplates.get(0).build();
  }
  
  public PolicyTemplate buildLastPolicyTemplate() {
    return this.policyTemplates.get(policyTemplates.size() - 1).build();
  }
  
  public PolicyTemplate buildMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
      for (PolicyTemplateBuilder item : policyTemplates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
      for (PolicyTemplateBuilder item : policyTemplates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPolicyTemplates(List<PolicyTemplate> policyTemplates) {
    if (this.policyTemplates != null) {
      this._visitables.get("policyTemplates").clear();
    }
    if (policyTemplates != null) {
        this.policyTemplates = new ArrayList();
        for (PolicyTemplate item : policyTemplates) {
          this.addToPolicyTemplates(item);
        }
    } else {
      this.policyTemplates = null;
    }
    return (A) this;
  }
  
  public A withPolicyTemplates(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PolicyTemplate... policyTemplates) {
    if (this.policyTemplates != null) {
        this.policyTemplates.clear();
        _visitables.remove("policyTemplates");
    }
    if (policyTemplates != null) {
      for (PolicyTemplate item : policyTemplates) {
        this.addToPolicyTemplates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPolicyTemplates() {
    return this.policyTemplates != null && !this.policyTemplates.isEmpty();
  }
  
  public PolicyTemplatesNested<A> addNewPolicyTemplate() {
    return new PolicyTemplatesNested(-1, null);
  }
  
  public PolicyTemplatesNested<A> addNewPolicyTemplateLike(PolicyTemplate item) {
    return new PolicyTemplatesNested(-1, item);
  }
  
  public PolicyTemplatesNested<A> setNewPolicyTemplateLike(int index,PolicyTemplate item) {
    return new PolicyTemplatesNested(index, item);
  }
  
  public PolicyTemplatesNested<A> editPolicyTemplate(int index) {
    if (policyTemplates.size() <= index) throw new RuntimeException("Can't edit policyTemplates. Index exceeds size.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public PolicyTemplatesNested<A> editFirstPolicyTemplate() {
    if (policyTemplates.size() == 0) throw new RuntimeException("Can't edit first policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(0, buildPolicyTemplate(0));
  }
  
  public PolicyTemplatesNested<A> editLastPolicyTemplate() {
    int index = policyTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policyTemplates. The list is empty.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public PolicyTemplatesNested<A> editMatchingPolicyTemplate(Predicate<PolicyTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policyTemplates.size();i++) { 
    if (predicate.test(policyTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policyTemplates. No match found.");
    return setNewPolicyTemplateLike(index, buildPolicyTemplate(index));
  }
  
  public String getRemediationAction() {
    return this.remediationAction;
  }
  
  public A withRemediationAction(String remediationAction) {
    this.remediationAction = remediationAction;
    return (A) this;
  }
  
  public boolean hasRemediationAction() {
    return this.remediationAction != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicySpecFluent that = (PolicySpecFluent) o;
    if (!java.util.Objects.equals(disabled, that.disabled)) return false;
    if (!java.util.Objects.equals(policyTemplates, that.policyTemplates)) return false;
    if (!java.util.Objects.equals(remediationAction, that.remediationAction)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(disabled,  policyTemplates,  remediationAction,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disabled != null) { sb.append("disabled:"); sb.append(disabled + ","); }
    if (policyTemplates != null && !policyTemplates.isEmpty()) { sb.append("policyTemplates:"); sb.append(policyTemplates + ","); }
    if (remediationAction != null) { sb.append("remediationAction:"); sb.append(remediationAction + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisabled() {
    return withDisabled(true);
  }
  public class PolicyTemplatesNested<N> extends PolicyTemplateFluent<PolicyTemplatesNested<N>> implements Nested<N>{
    PolicyTemplatesNested(int index,PolicyTemplate item) {
      this.index = index;
      this.builder = new PolicyTemplateBuilder(this, item);
    }
    PolicyTemplateBuilder builder;
    int index;
    
    public N and() {
      return (N) PolicySpecFluent.this.setToPolicyTemplates(index,builder.build());
    }
    
    public N endPolicyTemplate() {
      return and();
    }
    
  
  }

}