package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PlacementBindingBuilder extends PlacementBindingFluent<PlacementBindingBuilder> implements VisitableBuilder<PlacementBinding,PlacementBindingBuilder>{
  public PlacementBindingBuilder() {
    this(new PlacementBinding());
  }
  
  public PlacementBindingBuilder(PlacementBindingFluent<?> fluent) {
    this(fluent, new PlacementBinding());
  }
  
  public PlacementBindingBuilder(PlacementBindingFluent<?> fluent,PlacementBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PlacementBindingBuilder(PlacementBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PlacementBindingFluent<?> fluent;
  
  public PlacementBinding build() {
    PlacementBinding buildable = new PlacementBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildPlacementRef(),fluent.buildStatus(),fluent.buildSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}