package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyTemplateBuilder extends PolicyTemplateFluentImpl<PolicyTemplateBuilder> implements VisitableBuilder<PolicyTemplate,PolicyTemplateBuilder>{
  public PolicyTemplateBuilder() {
    this(false);
  }
  public PolicyTemplateBuilder(Boolean validationEnabled) {
    this(new PolicyTemplate(), validationEnabled);
  }
  public PolicyTemplateBuilder(PolicyTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyTemplateBuilder(PolicyTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyTemplate(), validationEnabled);
  }
  public PolicyTemplateBuilder(PolicyTemplateFluent<?> fluent,PolicyTemplate instance) {
    this(fluent, instance, false);
  }
  public PolicyTemplateBuilder(PolicyTemplateFluent<?> fluent,PolicyTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withObjectDefinition(instance.getObjectDefinition()); 
    this.validationEnabled = validationEnabled; 
  }
  public PolicyTemplateBuilder(PolicyTemplate instance) {
    this(instance,false);
  }
  public PolicyTemplateBuilder(PolicyTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withObjectDefinition(instance.getObjectDefinition()); 
    this.validationEnabled = validationEnabled; 
  }
  PolicyTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyTemplate build() {
    PolicyTemplate buildable = new PolicyTemplate(fluent.getObjectDefinition());
    return buildable;
  }
  
}