package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementBuilder extends PlacementFluentImpl<PlacementBuilder> implements VisitableBuilder<Placement,PlacementBuilder>{
  public PlacementBuilder() {
    this(false);
  }
  public PlacementBuilder(Boolean validationEnabled) {
    this(new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance) {
    this(fluent, instance, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDecisions(instance.getDecisions()); 
    fluent.withPlacement(instance.getPlacement()); 
    fluent.withPlacementBinding(instance.getPlacementBinding()); 
    fluent.withPlacementRule(instance.getPlacementRule()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementBuilder(Placement instance) {
    this(instance,false);
  }
  public PlacementBuilder(Placement instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDecisions(instance.getDecisions()); 
    this.withPlacement(instance.getPlacement()); 
    this.withPlacementBinding(instance.getPlacementBinding()); 
    this.withPlacementRule(instance.getPlacementRule()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementFluent<?> fluent;
  Boolean validationEnabled;
  public Placement build() {
    Placement buildable = new Placement(fluent.getDecisions(),fluent.getPlacement(),fluent.getPlacementBinding(),fluent.getPlacementRule());
    return buildable;
  }
  
}