package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DetailsPerTemplateFluentImpl<A extends DetailsPerTemplateFluent<A>> extends BaseFluent<A> implements DetailsPerTemplateFluent<A>{
  public DetailsPerTemplateFluentImpl() {
  }
  public DetailsPerTemplateFluentImpl(DetailsPerTemplate instance) {
    this.withCompliant(instance.getCompliant()); 
    this.withHistory(instance.getHistory()); 
    this.withTemplateMeta(instance.getTemplateMeta()); 
  }
  private String compliant;
  private ArrayList<ComplianceHistoryBuilder> history = new ArrayList<ComplianceHistoryBuilder>();
  private ObjectMetaBuilder templateMeta;
  public String getCompliant() {
    return this.compliant;
  }
  public A withCompliant(String compliant) {
    this.compliant=compliant; return (A) this;
  }
  public Boolean hasCompliant() {
    return this.compliant != null;
  }
  public A addToHistory(Integer index,ComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").add(index >= 0 ? index : _visitables.get("history").size(), builder);this.history.add(index >= 0 ? index : history.size(), builder); return (A)this;
  }
  public A setToHistory(Integer index,ComplianceHistory item) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
    if (index < 0 || index >= _visitables.get("history").size()) { _visitables.get("history").add(builder); } else { _visitables.get("history").set(index, builder);}
    if (index < 0 || index >= history.size()) { history.add(builder); } else { history.set(index, builder);}
     return (A)this;
  }
  public A addToHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... items) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A addAllToHistory(Collection<ComplianceHistory> items) {
    if (this.history == null) {this.history = new ArrayList<ComplianceHistoryBuilder>();}
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A removeFromHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... items) {
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
  }
  public A removeAllFromHistory(Collection<ComplianceHistory> items) {
    for (ComplianceHistory item : items) {ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    if (history == null) return (A) this;
    final Iterator<ComplianceHistoryBuilder> each = history.iterator();
    final List visitables = _visitables.get("history");
    while (each.hasNext()) {
      ComplianceHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHistory instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComplianceHistory> getHistory() {
    return history != null ? build(history) : null;
  }
  public List<ComplianceHistory> buildHistory() {
    return history != null ? build(history) : null;
  }
  public ComplianceHistory buildHistory(Integer index) {
    return this.history.get(index).build();
  }
  public ComplianceHistory buildFirstHistory() {
    return this.history.get(0).build();
  }
  public ComplianceHistory buildLastHistory() {
    return this.history.get(history.size() - 1).build();
  }
  public ComplianceHistory buildMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    for (ComplianceHistoryBuilder item: history) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    for (ComplianceHistoryBuilder item: history) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHistory(List<ComplianceHistory> history) {
    if (this.history != null) { _visitables.get("history").removeAll(this.history);}
    if (history != null) {this.history = new ArrayList(); for (ComplianceHistory item : history){this.addToHistory(item);}} else { this.history = null;} return (A) this;
  }
  public A withHistory(io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory... history) {
    if (this.history != null) {this.history.clear();}
    if (history != null) {for (ComplianceHistory item :history){ this.addToHistory(item);}} return (A) this;
  }
  public Boolean hasHistory() {
    return history != null && !history.isEmpty();
  }
  public A addNewHistory(String eventName,String lastTimestamp,String message) {
    return (A)addToHistory(new ComplianceHistory(eventName, lastTimestamp, message));
  }
  public DetailsPerTemplateFluent.HistoryNested<A> addNewHistory() {
    return new DetailsPerTemplateFluentImpl.HistoryNestedImpl();
  }
  public DetailsPerTemplateFluent.HistoryNested<A> addNewHistoryLike(ComplianceHistory item) {
    return new DetailsPerTemplateFluentImpl.HistoryNestedImpl(-1, item);
  }
  public DetailsPerTemplateFluent.HistoryNested<A> setNewHistoryLike(Integer index,ComplianceHistory item) {
    return new DetailsPerTemplateFluentImpl.HistoryNestedImpl(index, item);
  }
  public DetailsPerTemplateFluent.HistoryNested<A> editHistory(Integer index) {
    if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public DetailsPerTemplateFluent.HistoryNested<A> editFirstHistory() {
    if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
    return setNewHistoryLike(0, buildHistory(0));
  }
  public DetailsPerTemplateFluent.HistoryNested<A> editLastHistory() {
    int index = history.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public DetailsPerTemplateFluent.HistoryNested<A> editMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<history.size();i++) { 
    if (predicate.test(history.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTemplateMeta instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getTemplateMeta() {
    return this.templateMeta!=null ?this.templateMeta.build():null;
  }
  public ObjectMeta buildTemplateMeta() {
    return this.templateMeta!=null ?this.templateMeta.build():null;
  }
  public A withTemplateMeta(ObjectMeta templateMeta) {
    _visitables.get("templateMeta").remove(this.templateMeta);
    if (templateMeta!=null){ this.templateMeta= new ObjectMetaBuilder(templateMeta); _visitables.get("templateMeta").add(this.templateMeta);} else { this.templateMeta = null; _visitables.get("templateMeta").remove(this.templateMeta); } return (A) this;
  }
  public Boolean hasTemplateMeta() {
    return this.templateMeta != null;
  }
  public DetailsPerTemplateFluent.TemplateMetaNested<A> withNewTemplateMeta() {
    return new DetailsPerTemplateFluentImpl.TemplateMetaNestedImpl();
  }
  public DetailsPerTemplateFluent.TemplateMetaNested<A> withNewTemplateMetaLike(ObjectMeta item) {
    return new DetailsPerTemplateFluentImpl.TemplateMetaNestedImpl(item);
  }
  public DetailsPerTemplateFluent.TemplateMetaNested<A> editTemplateMeta() {
    return withNewTemplateMetaLike(getTemplateMeta());
  }
  public DetailsPerTemplateFluent.TemplateMetaNested<A> editOrNewTemplateMeta() {
    return withNewTemplateMetaLike(getTemplateMeta() != null ? getTemplateMeta(): new ObjectMetaBuilder().build());
  }
  public DetailsPerTemplateFluent.TemplateMetaNested<A> editOrNewTemplateMetaLike(ObjectMeta item) {
    return withNewTemplateMetaLike(getTemplateMeta() != null ? getTemplateMeta(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DetailsPerTemplateFluentImpl that = (DetailsPerTemplateFluentImpl) o;
    if (compliant != null ? !compliant.equals(that.compliant) :that.compliant != null) return false;
    if (history != null ? !history.equals(that.history) :that.history != null) return false;
    if (templateMeta != null ? !templateMeta.equals(that.templateMeta) :that.templateMeta != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(compliant,  history,  templateMeta,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (compliant != null) { sb.append("compliant:"); sb.append(compliant + ","); }
    if (history != null && !history.isEmpty()) { sb.append("history:"); sb.append(history + ","); }
    if (templateMeta != null) { sb.append("templateMeta:"); sb.append(templateMeta); }
    sb.append("}");
    return sb.toString();
  }
  class HistoryNestedImpl<N> extends ComplianceHistoryFluentImpl<DetailsPerTemplateFluent.HistoryNested<N>> implements DetailsPerTemplateFluent.HistoryNested<N>,Nested<N>{
    HistoryNestedImpl(Integer index,ComplianceHistory item) {
      this.index = index;
      this.builder = new ComplianceHistoryBuilder(this, item);
    }
    HistoryNestedImpl() {
      this.index = -1;
      this.builder = new ComplianceHistoryBuilder(this);
    }
    ComplianceHistoryBuilder builder;
    Integer index;
    public N and() {
      return (N) DetailsPerTemplateFluentImpl.this.setToHistory(index,builder.build());
    }
    public N endHistory() {
      return and();
    }
    
  }
  class TemplateMetaNestedImpl<N> extends ObjectMetaFluentImpl<DetailsPerTemplateFluent.TemplateMetaNested<N>> implements DetailsPerTemplateFluent.TemplateMetaNested<N>,Nested<N>{
    TemplateMetaNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    TemplateMetaNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) DetailsPerTemplateFluentImpl.this.withTemplateMeta(builder.build());
    }
    public N endTemplateMeta() {
      return and();
    }
    
  }
  
}