/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistory;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistoryBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.ComplianceHistoryFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplate;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.DetailsPerTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DetailsPerTemplateFluentImpl<A extends DetailsPerTemplateFluent<A>>
extends BaseFluent<A>
implements DetailsPerTemplateFluent<A> {
    private String compliant;
    private ArrayList<ComplianceHistoryBuilder> history = new ArrayList();
    private ObjectMetaBuilder templateMeta;

    public DetailsPerTemplateFluentImpl() {
    }

    public DetailsPerTemplateFluentImpl(DetailsPerTemplate instance) {
        this.withCompliant(instance.getCompliant());
        this.withHistory(instance.getHistory());
        this.withTemplateMeta(instance.getTemplateMeta());
    }

    @Override
    public String getCompliant() {
        return this.compliant;
    }

    @Override
    public A withCompliant(String compliant) {
        this.compliant = compliant;
        return (A)this;
    }

    @Override
    public Boolean hasCompliant() {
        return this.compliant != null;
    }

    @Override
    public A addToHistory(Integer index, ComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
        this._visitables.get((Object)"history").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"history").size(), builder);
        this.history.add(index >= 0 ? index.intValue() : this.history.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHistory(Integer index, ComplianceHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"history").size()) {
            this._visitables.get((Object)"history").add(builder);
        } else {
            this._visitables.get((Object)"history").set(index, builder);
        }
        if (index < 0 || index >= this.history.size()) {
            this.history.add(builder);
        } else {
            this.history.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHistory(ComplianceHistory ... items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHistory(Collection<ComplianceHistory> items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHistory(ComplianceHistory ... items) {
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove(builder);
            if (this.history == null) continue;
            this.history.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHistory(Collection<ComplianceHistory> items) {
        for (ComplianceHistory item : items) {
            ComplianceHistoryBuilder builder = new ComplianceHistoryBuilder(item);
            this._visitables.get((Object)"history").remove(builder);
            if (this.history == null) continue;
            this.history.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        if (this.history == null) {
            return (A)this;
        }
        Iterator<ComplianceHistoryBuilder> each = this.history.iterator();
        List visitables = this._visitables.get((Object)"history");
        while (each.hasNext()) {
            ComplianceHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComplianceHistory> getHistory() {
        return this.history != null ? DetailsPerTemplateFluentImpl.build(this.history) : null;
    }

    @Override
    public List<ComplianceHistory> buildHistory() {
        return this.history != null ? DetailsPerTemplateFluentImpl.build(this.history) : null;
    }

    @Override
    public ComplianceHistory buildHistory(Integer index) {
        return this.history.get(index).build();
    }

    @Override
    public ComplianceHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    @Override
    public ComplianceHistory buildLastHistory() {
        return this.history.get(this.history.size() - 1).build();
    }

    @Override
    public ComplianceHistory buildMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        for (ComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        for (ComplianceHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHistory(List<ComplianceHistory> history) {
        if (this.history != null) {
            this._visitables.get((Object)"history").removeAll(this.history);
        }
        if (history != null) {
            this.history = new ArrayList();
            for (ComplianceHistory item : history) {
                this.addToHistory(item);
            }
        } else {
            this.history = null;
        }
        return (A)this;
    }

    @Override
    public A withHistory(ComplianceHistory ... history) {
        if (this.history != null) {
            this.history.clear();
        }
        if (history != null) {
            for (ComplianceHistory item : history) {
                this.addToHistory(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    @Override
    public A addNewHistory(String eventName, String lastTimestamp, String message) {
        return this.addToHistory(new ComplianceHistory(eventName, lastTimestamp, message));
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> addNewHistory() {
        return new HistoryNestedImpl();
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> addNewHistoryLike(ComplianceHistory item) {
        return new HistoryNestedImpl(-1, item);
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> setNewHistoryLike(Integer index, ComplianceHistory item) {
        return new HistoryNestedImpl(index, item);
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> editHistory(Integer index) {
        if (this.history.size() <= index) {
            throw new RuntimeException("Can't edit history. Index exceeds size.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> editFirstHistory() {
        if (this.history.size() == 0) {
            throw new RuntimeException("Can't edit first history. The list is empty.");
        }
        return this.setNewHistoryLike(0, this.buildHistory(0));
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> editLastHistory() {
        int index = this.history.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last history. The list is empty.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    public DetailsPerTemplateFluent.HistoryNested<A> editMatchingHistory(Predicate<ComplianceHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.history.size(); ++i) {
            if (!predicate.test(this.history.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching history. No match found.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    @Deprecated
    public ObjectMeta getTemplateMeta() {
        return this.templateMeta != null ? this.templateMeta.build() : null;
    }

    @Override
    public ObjectMeta buildTemplateMeta() {
        return this.templateMeta != null ? this.templateMeta.build() : null;
    }

    @Override
    public A withTemplateMeta(ObjectMeta templateMeta) {
        this._visitables.get((Object)"templateMeta").remove(this.templateMeta);
        if (templateMeta != null) {
            this.templateMeta = new ObjectMetaBuilder(templateMeta);
            this._visitables.get((Object)"templateMeta").add(this.templateMeta);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplateMeta() {
        return this.templateMeta != null;
    }

    @Override
    public DetailsPerTemplateFluent.TemplateMetaNested<A> withNewTemplateMeta() {
        return new TemplateMetaNestedImpl();
    }

    @Override
    public DetailsPerTemplateFluent.TemplateMetaNested<A> withNewTemplateMetaLike(ObjectMeta item) {
        return new TemplateMetaNestedImpl(item);
    }

    @Override
    public DetailsPerTemplateFluent.TemplateMetaNested<A> editTemplateMeta() {
        return this.withNewTemplateMetaLike(this.getTemplateMeta());
    }

    @Override
    public DetailsPerTemplateFluent.TemplateMetaNested<A> editOrNewTemplateMeta() {
        return this.withNewTemplateMetaLike(this.getTemplateMeta() != null ? this.getTemplateMeta() : new ObjectMetaBuilder().build());
    }

    @Override
    public DetailsPerTemplateFluent.TemplateMetaNested<A> editOrNewTemplateMetaLike(ObjectMeta item) {
        return this.withNewTemplateMetaLike(this.getTemplateMeta() != null ? this.getTemplateMeta() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailsPerTemplateFluentImpl that = (DetailsPerTemplateFluentImpl)o;
        if (this.compliant != null ? !this.compliant.equals(that.compliant) : that.compliant != null) {
            return false;
        }
        if (this.history != null ? !this.history.equals(that.history) : that.history != null) {
            return false;
        }
        return !(this.templateMeta != null ? !this.templateMeta.equals((Object)that.templateMeta) : that.templateMeta != null);
    }

    public int hashCode() {
        return Objects.hash(this.compliant, this.history, this.templateMeta, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compliant != null) {
            sb.append("compliant:");
            sb.append(this.compliant + ",");
        }
        if (this.history != null && !this.history.isEmpty()) {
            sb.append("history:");
            sb.append(this.history + ",");
        }
        if (this.templateMeta != null) {
            sb.append("templateMeta:");
            sb.append(this.templateMeta);
        }
        sb.append("}");
        return sb.toString();
    }

    class TemplateMetaNestedImpl<N>
    extends ObjectMetaFluentImpl<DetailsPerTemplateFluent.TemplateMetaNested<N>>
    implements DetailsPerTemplateFluent.TemplateMetaNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        TemplateMetaNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        TemplateMetaNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)DetailsPerTemplateFluentImpl.this.withTemplateMeta(this.builder.build());
        }

        @Override
        public N endTemplateMeta() {
            return this.and();
        }
    }

    class HistoryNestedImpl<N>
    extends ComplianceHistoryFluentImpl<DetailsPerTemplateFluent.HistoryNested<N>>
    implements DetailsPerTemplateFluent.HistoryNested<N>,
    Nested<N> {
        ComplianceHistoryBuilder builder;
        Integer index;

        HistoryNestedImpl(Integer index, ComplianceHistory item) {
            this.index = index;
            this.builder = new ComplianceHistoryBuilder(this, item);
        }

        HistoryNestedImpl() {
            this.index = -1;
            this.builder = new ComplianceHistoryBuilder(this);
        }

        @Override
        public N and() {
            return (N)DetailsPerTemplateFluentImpl.this.setToHistory(this.index, this.builder.build());
        }

        @Override
        public N endHistory() {
            return this.and();
        }
    }
}

