
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "disabled",
    "policy-templates",
    "remediationAction"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class PolicySpec implements KubernetesResource
{

    @JsonProperty("disabled")
    private Boolean disabled;
    @JsonProperty("policy-templates")
    private List<PolicyTemplate> policyTemplates = new ArrayList<PolicyTemplate>();
    @JsonProperty("remediationAction")
    private String remediationAction;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PolicySpec() {
    }

    /**
     * 
     * @param policyTemplates
     * @param remediationAction
     * @param disabled
     */
    public PolicySpec(Boolean disabled, List<PolicyTemplate> policyTemplates, String remediationAction) {
        super();
        this.disabled = disabled;
        this.policyTemplates = policyTemplates;
        this.remediationAction = remediationAction;
    }

    @JsonProperty("disabled")
    public Boolean getDisabled() {
        return disabled;
    }

    @JsonProperty("disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @JsonProperty("policy-templates")
    public List<PolicyTemplate> getPolicyTemplates() {
        return policyTemplates;
    }

    @JsonProperty("policy-templates")
    public void setPolicyTemplates(List<PolicyTemplate> policyTemplates) {
        this.policyTemplates = policyTemplates;
    }

    @JsonProperty("remediationAction")
    public String getRemediationAction() {
        return remediationAction;
    }

    @JsonProperty("remediationAction")
    public void setRemediationAction(String remediationAction) {
        this.remediationAction = remediationAction;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
