/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBinding;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBindingFluent;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBindingStatus;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBindingStatusBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementBindingStatusFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementSubject;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementSubjectBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.PlacementSubjectFluentImpl;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.Subject;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.SubjectBuilder;
import io.fabric8.openclustermanagement.api.model.governancepolicypropagator.policy.v1.SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PlacementBindingFluentImpl<A extends PlacementBindingFluent<A>>
extends BaseFluent<A>
implements PlacementBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PlacementSubjectBuilder placementRef;
    private PlacementBindingStatusBuilder status;
    private List<SubjectBuilder> subjects;

    public PlacementBindingFluentImpl() {
    }

    public PlacementBindingFluentImpl(PlacementBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPlacementRef(instance.getPlacementRef());
        this.withStatus(instance.getStatus());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PlacementBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PlacementBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PlacementBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PlacementBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PlacementBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public PlacementSubject getPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    @Override
    public PlacementSubject buildPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    @Override
    public A withPlacementRef(PlacementSubject placementRef) {
        this._visitables.get((Object)"placementRef").remove(this.placementRef);
        if (placementRef != null) {
            this.placementRef = new PlacementSubjectBuilder(placementRef);
            this._visitables.get((Object)"placementRef").add(this.placementRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlacementRef() {
        return this.placementRef != null;
    }

    @Override
    public A withNewPlacementRef(String apiGroup, String kind, String name) {
        return this.withPlacementRef(new PlacementSubject(apiGroup, kind, name));
    }

    @Override
    public PlacementBindingFluent.PlacementRefNested<A> withNewPlacementRef() {
        return new PlacementRefNestedImpl();
    }

    @Override
    public PlacementBindingFluent.PlacementRefNested<A> withNewPlacementRefLike(PlacementSubject item) {
        return new PlacementRefNestedImpl(item);
    }

    @Override
    public PlacementBindingFluent.PlacementRefNested<A> editPlacementRef() {
        return this.withNewPlacementRefLike(this.getPlacementRef());
    }

    @Override
    public PlacementBindingFluent.PlacementRefNested<A> editOrNewPlacementRef() {
        return this.withNewPlacementRefLike(this.getPlacementRef() != null ? this.getPlacementRef() : new PlacementSubjectBuilder().build());
    }

    @Override
    public PlacementBindingFluent.PlacementRefNested<A> editOrNewPlacementRefLike(PlacementSubject item) {
        return this.withNewPlacementRefLike(this.getPlacementRef() != null ? this.getPlacementRef() : item);
    }

    @Override
    @Deprecated
    public PlacementBindingStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public PlacementBindingStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(PlacementBindingStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new PlacementBindingStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public PlacementBindingFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PlacementBindingFluent.StatusNested<A> withNewStatusLike(PlacementBindingStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PlacementBindingFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public PlacementBindingFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new PlacementBindingStatusBuilder().build());
    }

    @Override
    public PlacementBindingFluent.StatusNested<A> editOrNewStatusLike(PlacementBindingStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A addToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        this._visitables.get((Object)"subjects").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"subjects").size(), builder);
        this.subjects.add(index >= 0 ? index.intValue() : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"subjects").size()) {
            this._visitables.get((Object)"subjects").add(builder);
        } else {
            this._visitables.get((Object)"subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get((Object)"subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        List visitables = this._visitables.get((Object)"subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subject> getSubjects() {
        return PlacementBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<Subject> buildSubjects() {
        return PlacementBindingFluentImpl.build(this.subjects);
    }

    @Override
    public Subject buildSubject(Integer index) {
        return this.subjects.get(index).build();
    }

    @Override
    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get((Object)"subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<SubjectBuilder>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name) {
        return this.addToSubjects(new Subject(apiGroup, kind, name));
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> setNewSubjectLike(Integer index, Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> editSubject(Integer index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public PlacementBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacementBindingFluentImpl that = (PlacementBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.placementRef != null ? !this.placementRef.equals(that.placementRef) : that.placementRef != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.placementRef, this.status, this.subjects, super.hashCode());
    }

    public class SubjectsNestedImpl<N>
    extends SubjectFluentImpl<PlacementBindingFluent.SubjectsNested<N>>
    implements PlacementBindingFluent.SubjectsNested<N>,
    Nested<N> {
        SubjectBuilder builder;
        Integer index;

        SubjectsNestedImpl(Integer index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class StatusNestedImpl<N>
    extends PlacementBindingStatusFluentImpl<PlacementBindingFluent.StatusNested<N>>
    implements PlacementBindingFluent.StatusNested<N>,
    Nested<N> {
        PlacementBindingStatusBuilder builder;

        StatusNestedImpl(PlacementBindingStatus item) {
            this.builder = new PlacementBindingStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PlacementBindingStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementBindingFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class PlacementRefNestedImpl<N>
    extends PlacementSubjectFluentImpl<PlacementBindingFluent.PlacementRefNested<N>>
    implements PlacementBindingFluent.PlacementRefNested<N>,
    Nested<N> {
        PlacementSubjectBuilder builder;

        PlacementRefNestedImpl(PlacementSubject item) {
            this.builder = new PlacementSubjectBuilder(this, item);
        }

        PlacementRefNestedImpl() {
            this.builder = new PlacementSubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementBindingFluentImpl.this.withPlacementRef(this.builder.build());
        }

        @Override
        public N endPlacementRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PlacementBindingFluent.MetadataNested<N>>
    implements PlacementBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)PlacementBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

