package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenerationStatusBuilder extends GenerationStatusFluent<GenerationStatusBuilder> implements VisitableBuilder<GenerationStatus,GenerationStatusBuilder>{
  public GenerationStatusBuilder() {
    this(new GenerationStatus());
  }
  
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent) {
    this(fluent, new GenerationStatus());
  }
  
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenerationStatusBuilder(GenerationStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenerationStatusFluent<?> fluent;
  
  public GenerationStatus build() {
    GenerationStatus buildable = new GenerationStatus(fluent.getGroup(),fluent.getLastGeneration(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}