package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MultiClusterHubSpecFluent<A extends MultiClusterHubSpecFluent<A>> extends BaseFluent<A>{
  public MultiClusterHubSpecFluent() {
  }
  
  public MultiClusterHubSpecFluent(MultiClusterHubSpec instance) {
    this.copyInstance(instance);
  }
  private String availabilityConfig;
  private String customCAConfigmap;
  private Boolean disableHubSelfManagement;
  private Boolean disableUpdateClusterImageSets;
  private Boolean enableClusterBackup;
  private Boolean enableClusterProxyAddon;
  private HiveConfigSpecBuilder hive;
  private String imagePullSecret;
  private IngressSpecBuilder ingress;
  private Map<String,String> nodeSelector;
  private OverridesBuilder overrides;
  private Boolean separateCertificateManagement;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MultiClusterHubSpec instance) {
    instance = (instance != null ? instance : new MultiClusterHubSpec());
    if (instance != null) {
          this.withAvailabilityConfig(instance.getAvailabilityConfig());
          this.withCustomCAConfigmap(instance.getCustomCAConfigmap());
          this.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
          this.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
          this.withEnableClusterBackup(instance.getEnableClusterBackup());
          this.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
          this.withHive(instance.getHive());
          this.withImagePullSecret(instance.getImagePullSecret());
          this.withIngress(instance.getIngress());
          this.withNodeSelector(instance.getNodeSelector());
          this.withOverrides(instance.getOverrides());
          this.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAvailabilityConfig() {
    return this.availabilityConfig;
  }
  
  public A withAvailabilityConfig(String availabilityConfig) {
    this.availabilityConfig = availabilityConfig;
    return (A) this;
  }
  
  public boolean hasAvailabilityConfig() {
    return this.availabilityConfig != null;
  }
  
  public String getCustomCAConfigmap() {
    return this.customCAConfigmap;
  }
  
  public A withCustomCAConfigmap(String customCAConfigmap) {
    this.customCAConfigmap = customCAConfigmap;
    return (A) this;
  }
  
  public boolean hasCustomCAConfigmap() {
    return this.customCAConfigmap != null;
  }
  
  public Boolean getDisableHubSelfManagement() {
    return this.disableHubSelfManagement;
  }
  
  public A withDisableHubSelfManagement(Boolean disableHubSelfManagement) {
    this.disableHubSelfManagement = disableHubSelfManagement;
    return (A) this;
  }
  
  public boolean hasDisableHubSelfManagement() {
    return this.disableHubSelfManagement != null;
  }
  
  public Boolean getDisableUpdateClusterImageSets() {
    return this.disableUpdateClusterImageSets;
  }
  
  public A withDisableUpdateClusterImageSets(Boolean disableUpdateClusterImageSets) {
    this.disableUpdateClusterImageSets = disableUpdateClusterImageSets;
    return (A) this;
  }
  
  public boolean hasDisableUpdateClusterImageSets() {
    return this.disableUpdateClusterImageSets != null;
  }
  
  public Boolean getEnableClusterBackup() {
    return this.enableClusterBackup;
  }
  
  public A withEnableClusterBackup(Boolean enableClusterBackup) {
    this.enableClusterBackup = enableClusterBackup;
    return (A) this;
  }
  
  public boolean hasEnableClusterBackup() {
    return this.enableClusterBackup != null;
  }
  
  public Boolean getEnableClusterProxyAddon() {
    return this.enableClusterProxyAddon;
  }
  
  public A withEnableClusterProxyAddon(Boolean enableClusterProxyAddon) {
    this.enableClusterProxyAddon = enableClusterProxyAddon;
    return (A) this;
  }
  
  public boolean hasEnableClusterProxyAddon() {
    return this.enableClusterProxyAddon != null;
  }
  
  public HiveConfigSpec buildHive() {
    return this.hive != null ? this.hive.build() : null;
  }
  
  public A withHive(HiveConfigSpec hive) {
    this._visitables.remove("hive");
    if (hive != null) {
        this.hive = new HiveConfigSpecBuilder(hive);
        this._visitables.get("hive").add(this.hive);
    } else {
        this.hive = null;
        this._visitables.get("hive").remove(this.hive);
    }
    return (A) this;
  }
  
  public boolean hasHive() {
    return this.hive != null;
  }
  
  public HiveNested<A> withNewHive() {
    return new HiveNested(null);
  }
  
  public HiveNested<A> withNewHiveLike(HiveConfigSpec item) {
    return new HiveNested(item);
  }
  
  public HiveNested<A> editHive() {
    return withNewHiveLike(java.util.Optional.ofNullable(buildHive()).orElse(null));
  }
  
  public HiveNested<A> editOrNewHive() {
    return withNewHiveLike(java.util.Optional.ofNullable(buildHive()).orElse(new HiveConfigSpecBuilder().build()));
  }
  
  public HiveNested<A> editOrNewHiveLike(HiveConfigSpec item) {
    return withNewHiveLike(java.util.Optional.ofNullable(buildHive()).orElse(item));
  }
  
  public String getImagePullSecret() {
    return this.imagePullSecret;
  }
  
  public A withImagePullSecret(String imagePullSecret) {
    this.imagePullSecret = imagePullSecret;
    return (A) this;
  }
  
  public boolean hasImagePullSecret() {
    return this.imagePullSecret != null;
  }
  
  public IngressSpec buildIngress() {
    return this.ingress != null ? this.ingress.build() : null;
  }
  
  public A withIngress(IngressSpec ingress) {
    this._visitables.remove("ingress");
    if (ingress != null) {
        this.ingress = new IngressSpecBuilder(ingress);
        this._visitables.get("ingress").add(this.ingress);
    } else {
        this.ingress = null;
        this._visitables.get("ingress").remove(this.ingress);
    }
    return (A) this;
  }
  
  public boolean hasIngress() {
    return this.ingress != null;
  }
  
  public IngressNested<A> withNewIngress() {
    return new IngressNested(null);
  }
  
  public IngressNested<A> withNewIngressLike(IngressSpec item) {
    return new IngressNested(item);
  }
  
  public IngressNested<A> editIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(null));
  }
  
  public IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(new IngressSpecBuilder().build()));
  }
  
  public IngressNested<A> editOrNewIngressLike(IngressSpec item) {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(item));
  }
  
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) {
      this.nodeSelector = null;
    } else {
      this.nodeSelector = new LinkedHashMap(nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public Overrides buildOverrides() {
    return this.overrides != null ? this.overrides.build() : null;
  }
  
  public A withOverrides(Overrides overrides) {
    this._visitables.remove("overrides");
    if (overrides != null) {
        this.overrides = new OverridesBuilder(overrides);
        this._visitables.get("overrides").add(this.overrides);
    } else {
        this.overrides = null;
        this._visitables.get("overrides").remove(this.overrides);
    }
    return (A) this;
  }
  
  public boolean hasOverrides() {
    return this.overrides != null;
  }
  
  public A withNewOverrides(String imagePullPolicy) {
    return (A)withOverrides(new Overrides(imagePullPolicy));
  }
  
  public OverridesNested<A> withNewOverrides() {
    return new OverridesNested(null);
  }
  
  public OverridesNested<A> withNewOverridesLike(Overrides item) {
    return new OverridesNested(item);
  }
  
  public OverridesNested<A> editOverrides() {
    return withNewOverridesLike(java.util.Optional.ofNullable(buildOverrides()).orElse(null));
  }
  
  public OverridesNested<A> editOrNewOverrides() {
    return withNewOverridesLike(java.util.Optional.ofNullable(buildOverrides()).orElse(new OverridesBuilder().build()));
  }
  
  public OverridesNested<A> editOrNewOverridesLike(Overrides item) {
    return withNewOverridesLike(java.util.Optional.ofNullable(buildOverrides()).orElse(item));
  }
  
  public Boolean getSeparateCertificateManagement() {
    return this.separateCertificateManagement;
  }
  
  public A withSeparateCertificateManagement(Boolean separateCertificateManagement) {
    this.separateCertificateManagement = separateCertificateManagement;
    return (A) this;
  }
  
  public boolean hasSeparateCertificateManagement() {
    return this.separateCertificateManagement != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MultiClusterHubSpecFluent that = (MultiClusterHubSpecFluent) o;
    if (!java.util.Objects.equals(availabilityConfig, that.availabilityConfig)) return false;
    if (!java.util.Objects.equals(customCAConfigmap, that.customCAConfigmap)) return false;
    if (!java.util.Objects.equals(disableHubSelfManagement, that.disableHubSelfManagement)) return false;
    if (!java.util.Objects.equals(disableUpdateClusterImageSets, that.disableUpdateClusterImageSets)) return false;
    if (!java.util.Objects.equals(enableClusterBackup, that.enableClusterBackup)) return false;
    if (!java.util.Objects.equals(enableClusterProxyAddon, that.enableClusterProxyAddon)) return false;
    if (!java.util.Objects.equals(hive, that.hive)) return false;
    if (!java.util.Objects.equals(imagePullSecret, that.imagePullSecret)) return false;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(overrides, that.overrides)) return false;
    if (!java.util.Objects.equals(separateCertificateManagement, that.separateCertificateManagement)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(availabilityConfig,  customCAConfigmap,  disableHubSelfManagement,  disableUpdateClusterImageSets,  enableClusterBackup,  enableClusterProxyAddon,  hive,  imagePullSecret,  ingress,  nodeSelector,  overrides,  separateCertificateManagement,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availabilityConfig != null) { sb.append("availabilityConfig:"); sb.append(availabilityConfig + ","); }
    if (customCAConfigmap != null) { sb.append("customCAConfigmap:"); sb.append(customCAConfigmap + ","); }
    if (disableHubSelfManagement != null) { sb.append("disableHubSelfManagement:"); sb.append(disableHubSelfManagement + ","); }
    if (disableUpdateClusterImageSets != null) { sb.append("disableUpdateClusterImageSets:"); sb.append(disableUpdateClusterImageSets + ","); }
    if (enableClusterBackup != null) { sb.append("enableClusterBackup:"); sb.append(enableClusterBackup + ","); }
    if (enableClusterProxyAddon != null) { sb.append("enableClusterProxyAddon:"); sb.append(enableClusterProxyAddon + ","); }
    if (hive != null) { sb.append("hive:"); sb.append(hive + ","); }
    if (imagePullSecret != null) { sb.append("imagePullSecret:"); sb.append(imagePullSecret + ","); }
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (overrides != null) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (separateCertificateManagement != null) { sb.append("separateCertificateManagement:"); sb.append(separateCertificateManagement + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisableHubSelfManagement() {
    return withDisableHubSelfManagement(true);
  }
  
  public A withDisableUpdateClusterImageSets() {
    return withDisableUpdateClusterImageSets(true);
  }
  
  public A withEnableClusterBackup() {
    return withEnableClusterBackup(true);
  }
  
  public A withEnableClusterProxyAddon() {
    return withEnableClusterProxyAddon(true);
  }
  
  public A withSeparateCertificateManagement() {
    return withSeparateCertificateManagement(true);
  }
  public class HiveNested<N> extends HiveConfigSpecFluent<HiveNested<N>> implements Nested<N>{
    HiveNested(HiveConfigSpec item) {
      this.builder = new HiveConfigSpecBuilder(this, item);
    }
    HiveConfigSpecBuilder builder;
    
    public N and() {
      return (N) MultiClusterHubSpecFluent.this.withHive(builder.build());
    }
    
    public N endHive() {
      return and();
    }
    
  
  }
  public class IngressNested<N> extends IngressSpecFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(IngressSpec item) {
      this.builder = new IngressSpecBuilder(this, item);
    }
    IngressSpecBuilder builder;
    
    public N and() {
      return (N) MultiClusterHubSpecFluent.this.withIngress(builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }
  public class OverridesNested<N> extends OverridesFluent<OverridesNested<N>> implements Nested<N>{
    OverridesNested(Overrides item) {
      this.builder = new OverridesBuilder(this, item);
    }
    OverridesBuilder builder;
    
    public N and() {
      return (N) MultiClusterHubSpecFluent.this.withOverrides(builder.build());
    }
    
    public N endOverrides() {
      return and();
    }
    
  
  }

}