/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.IngressSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluent<A extends IngressSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> sslCiphers = new ArrayList<String>();

    public IngressSpecFluent() {
    }

    public IngressSpecFluent(IngressSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressSpec instance) {
        IngressSpec ingressSpec = instance = instance != null ? instance : new IngressSpec();
        if (instance != null) {
            this.withSslCiphers(instance.getSslCiphers());
            this.withSslCiphers(instance.getSslCiphers());
        }
    }

    public A addToSslCiphers(int index, String item) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        this.sslCiphers.add(index, item);
        return (A)((Object)this);
    }

    public A setToSslCiphers(int index, String item) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        this.sslCiphers.set(index, item);
        return (A)((Object)this);
    }

    public A addToSslCiphers(String ... items) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.sslCiphers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSslCiphers(Collection<String> items) {
        if (this.sslCiphers == null) {
            this.sslCiphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.sslCiphers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSslCiphers(String ... items) {
        if (this.sslCiphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sslCiphers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSslCiphers(Collection<String> items) {
        if (this.sslCiphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sslCiphers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSslCiphers() {
        return this.sslCiphers;
    }

    public String getSslCipher(int index) {
        return this.sslCiphers.get(index);
    }

    public String getFirstSslCipher() {
        return this.sslCiphers.get(0);
    }

    public String getLastSslCipher() {
        return this.sslCiphers.get(this.sslCiphers.size() - 1);
    }

    public String getMatchingSslCipher(Predicate<String> predicate) {
        for (String item : this.sslCiphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSslCipher(Predicate<String> predicate) {
        for (String item : this.sslCiphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSslCiphers(List<String> sslCiphers) {
        if (sslCiphers != null) {
            this.sslCiphers = new ArrayList<String>();
            for (String item : sslCiphers) {
                this.addToSslCiphers(item);
            }
        } else {
            this.sslCiphers = null;
        }
        return (A)((Object)this);
    }

    public A withSslCiphers(String ... sslCiphers) {
        if (this.sslCiphers != null) {
            this.sslCiphers.clear();
            this._visitables.remove((Object)"sslCiphers");
        }
        if (sslCiphers != null) {
            for (String item : sslCiphers) {
                this.addToSslCiphers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSslCiphers() {
        return this.sslCiphers != null && !this.sslCiphers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecFluent that = (IngressSpecFluent)((Object)o);
        return Objects.equals(this.sslCiphers, that.sslCiphers);
    }

    public int hashCode() {
        return Objects.hash(this.sslCiphers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sslCiphers != null && !this.sslCiphers.isEmpty()) {
            sb.append("sslCiphers:");
            sb.append(this.sslCiphers);
        }
        sb.append("}");
        return sb.toString();
    }
}

