package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterManagerStatusBuilder extends ClusterManagerStatusFluent<ClusterManagerStatusBuilder> implements VisitableBuilder<ClusterManagerStatus,ClusterManagerStatusBuilder>{
  public ClusterManagerStatusBuilder() {
    this(new ClusterManagerStatus());
  }
  
  public ClusterManagerStatusBuilder(ClusterManagerStatusFluent<?> fluent) {
    this(fluent, new ClusterManagerStatus());
  }
  
  public ClusterManagerStatusBuilder(ClusterManagerStatusFluent<?> fluent,ClusterManagerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterManagerStatusBuilder(ClusterManagerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterManagerStatusFluent<?> fluent;
  
  public ClusterManagerStatus build() {
    ClusterManagerStatus buildable = new ClusterManagerStatus(fluent.getConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.buildRelatedResources());
    return buildable;
  }
  

}