package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterManagerBuilder extends ClusterManagerFluent<ClusterManagerBuilder> implements VisitableBuilder<ClusterManager,ClusterManagerBuilder>{
  public ClusterManagerBuilder() {
    this(new ClusterManager());
  }
  
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent) {
    this(fluent, new ClusterManager());
  }
  
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent,ClusterManager instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterManagerBuilder(ClusterManager instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterManagerFluent<?> fluent;
  
  public ClusterManager build() {
    ClusterManager buildable = new ClusterManager(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}