package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MultiClusterHubSpecBuilder extends MultiClusterHubSpecFluent<MultiClusterHubSpecBuilder> implements VisitableBuilder<MultiClusterHubSpec,MultiClusterHubSpecBuilder>{
  public MultiClusterHubSpecBuilder() {
    this(new MultiClusterHubSpec());
  }
  
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent) {
    this(fluent, new MultiClusterHubSpec());
  }
  
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent,MultiClusterHubSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MultiClusterHubSpecBuilder(MultiClusterHubSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MultiClusterHubSpecFluent<?> fluent;
  
  public MultiClusterHubSpec build() {
    MultiClusterHubSpec buildable = new MultiClusterHubSpec(fluent.getAvailabilityConfig(),fluent.getCustomCAConfigmap(),fluent.getDisableHubSelfManagement(),fluent.getDisableUpdateClusterImageSets(),fluent.getEnableClusterBackup(),fluent.getEnableClusterProxyAddon(),fluent.buildHive(),fluent.getImagePullSecret(),fluent.buildIngress(),fluent.getNodeSelector(),fluent.buildOverrides(),fluent.getSeparateCertificateManagement());
    return buildable;
  }
  

}