package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HiveConfigSpecFluent<A extends HiveConfigSpecFluent<A>> extends BaseFluent<A>{
  public HiveConfigSpecFluent() {
  }
  
  public HiveConfigSpecFluent(HiveConfigSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LocalObjectReferenceBuilder> additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();
  private BackupConfigBuilder backup;
  private ExternalDNSConfigBuilder externalDNS;
  private FailedProvisionConfigBuilder failedProvisionConfig;
  private LocalObjectReferenceBuilder globalPullSecret;
  private Boolean maintenanceMode;
  
  protected void copyInstance(HiveConfigSpec instance) {
    instance = (instance != null ? instance : new HiveConfigSpec());
    if (instance != null) {
          this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
          this.withBackup(instance.getBackup());
          this.withExternalDNS(instance.getExternalDNS());
          this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
          this.withGlobalPullSecret(instance.getGlobalPullSecret());
          this.withMaintenanceMode(instance.getMaintenanceMode());
          this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
          this.withBackup(instance.getBackup());
          this.withExternalDNS(instance.getExternalDNS());
          this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
          this.withGlobalPullSecret(instance.getGlobalPullSecret());
          this.withMaintenanceMode(instance.getMaintenanceMode());
        }
  }
  
  public A addToAdditionalCertificateAuthorities(int index,LocalObjectReference item) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= additionalCertificateAuthorities.size()) { _visitables.get("additionalCertificateAuthorities").add(builder); additionalCertificateAuthorities.add(builder); } else { _visitables.get("additionalCertificateAuthorities").add(index, builder); additionalCertificateAuthorities.add(index, builder);}
    return (A)this;
  }
  
  public A setToAdditionalCertificateAuthorities(int index,LocalObjectReference item) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= additionalCertificateAuthorities.size()) { _visitables.get("additionalCertificateAuthorities").add(builder); additionalCertificateAuthorities.add(builder); } else { _visitables.get("additionalCertificateAuthorities").set(index, builder); additionalCertificateAuthorities.set(index, builder);}
    return (A)this;
  }
  
  public A addToAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").add(builder);this.additionalCertificateAuthorities.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").add(builder);this.additionalCertificateAuthorities.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.additionalCertificateAuthorities == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").remove(builder); this.additionalCertificateAuthorities.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
    if (this.additionalCertificateAuthorities == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").remove(builder); this.additionalCertificateAuthorities.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalCertificateAuthorities(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (additionalCertificateAuthorities == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = additionalCertificateAuthorities.iterator();
    final List visitables = _visitables.get("additionalCertificateAuthorities");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildAdditionalCertificateAuthorities() {
    return this.additionalCertificateAuthorities != null ? build(additionalCertificateAuthorities) : null;
  }
  
  public LocalObjectReference buildAdditionalCertificateAuthority(int index) {
    return this.additionalCertificateAuthorities.get(index).build();
  }
  
  public LocalObjectReference buildFirstAdditionalCertificateAuthority() {
    return this.additionalCertificateAuthorities.get(0).build();
  }
  
  public LocalObjectReference buildLastAdditionalCertificateAuthority() {
    return this.additionalCertificateAuthorities.get(additionalCertificateAuthorities.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : additionalCertificateAuthorities) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : additionalCertificateAuthorities) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalCertificateAuthorities(List<LocalObjectReference> additionalCertificateAuthorities) {
    if (this.additionalCertificateAuthorities != null) {
      this._visitables.get("additionalCertificateAuthorities").clear();
    }
    if (additionalCertificateAuthorities != null) {
        this.additionalCertificateAuthorities = new ArrayList();
        for (LocalObjectReference item : additionalCertificateAuthorities) {
          this.addToAdditionalCertificateAuthorities(item);
        }
    } else {
      this.additionalCertificateAuthorities = null;
    }
    return (A) this;
  }
  
  public A withAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... additionalCertificateAuthorities) {
    if (this.additionalCertificateAuthorities != null) {this.additionalCertificateAuthorities.clear(); _visitables.remove("additionalCertificateAuthorities"); }
    if (additionalCertificateAuthorities != null) {for (LocalObjectReference item :additionalCertificateAuthorities){ this.addToAdditionalCertificateAuthorities(item);}} return (A) this;
  }
  
  public boolean hasAdditionalCertificateAuthorities() {
    return this.additionalCertificateAuthorities != null && !this.additionalCertificateAuthorities.isEmpty();
  }
  
  public A addNewAdditionalCertificateAuthority(String name) {
    return (A)addToAdditionalCertificateAuthorities(new LocalObjectReference(name));
  }
  
  public AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthority() {
    return new AdditionalCertificateAuthoritiesNested(-1, null);
  }
  
  public AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthorityLike(LocalObjectReference item) {
    return new AdditionalCertificateAuthoritiesNested(-1, item);
  }
  
  public AdditionalCertificateAuthoritiesNested<A> setNewAdditionalCertificateAuthorityLike(int index,LocalObjectReference item) {
    return new AdditionalCertificateAuthoritiesNested(index, item);
  }
  
  public AdditionalCertificateAuthoritiesNested<A> editAdditionalCertificateAuthority(int index) {
    if (additionalCertificateAuthorities.size() <= index) throw new RuntimeException("Can't edit additionalCertificateAuthorities. Index exceeds size.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  
  public AdditionalCertificateAuthoritiesNested<A> editFirstAdditionalCertificateAuthority() {
    if (additionalCertificateAuthorities.size() == 0) throw new RuntimeException("Can't edit first additionalCertificateAuthorities. The list is empty.");
    return setNewAdditionalCertificateAuthorityLike(0, buildAdditionalCertificateAuthority(0));
  }
  
  public AdditionalCertificateAuthoritiesNested<A> editLastAdditionalCertificateAuthority() {
    int index = additionalCertificateAuthorities.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalCertificateAuthorities. The list is empty.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  
  public AdditionalCertificateAuthoritiesNested<A> editMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalCertificateAuthorities.size();i++) { 
    if (predicate.test(additionalCertificateAuthorities.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalCertificateAuthorities. No match found.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  
  public BackupConfig buildBackup() {
    return this.backup != null ? this.backup.build() : null;
  }
  
  public A withBackup(BackupConfig backup) {
    this._visitables.remove(this.backup);
    if (backup != null) {
        this.backup = new BackupConfigBuilder(backup);
        this._visitables.get("backup").add(this.backup);
    } else {
        this.backup = null;
        this._visitables.get("backup").remove(this.backup);
    }
    return (A) this;
  }
  
  public boolean hasBackup() {
    return this.backup != null;
  }
  
  public BackupNested<A> withNewBackup() {
    return new BackupNested(null);
  }
  
  public BackupNested<A> withNewBackupLike(BackupConfig item) {
    return new BackupNested(item);
  }
  
  public BackupNested<A> editBackup() {
    return withNewBackupLike(java.util.Optional.ofNullable(buildBackup()).orElse(null));
  }
  
  public BackupNested<A> editOrNewBackup() {
    return withNewBackupLike(java.util.Optional.ofNullable(buildBackup()).orElse(new BackupConfigBuilder().build()));
  }
  
  public BackupNested<A> editOrNewBackupLike(BackupConfig item) {
    return withNewBackupLike(java.util.Optional.ofNullable(buildBackup()).orElse(item));
  }
  
  public ExternalDNSConfig buildExternalDNS() {
    return this.externalDNS != null ? this.externalDNS.build() : null;
  }
  
  public A withExternalDNS(ExternalDNSConfig externalDNS) {
    this._visitables.remove(this.externalDNS);
    if (externalDNS != null) {
        this.externalDNS = new ExternalDNSConfigBuilder(externalDNS);
        this._visitables.get("externalDNS").add(this.externalDNS);
    } else {
        this.externalDNS = null;
        this._visitables.get("externalDNS").remove(this.externalDNS);
    }
    return (A) this;
  }
  
  public boolean hasExternalDNS() {
    return this.externalDNS != null;
  }
  
  public ExternalDNSNested<A> withNewExternalDNS() {
    return new ExternalDNSNested(null);
  }
  
  public ExternalDNSNested<A> withNewExternalDNSLike(ExternalDNSConfig item) {
    return new ExternalDNSNested(item);
  }
  
  public ExternalDNSNested<A> editExternalDNS() {
    return withNewExternalDNSLike(java.util.Optional.ofNullable(buildExternalDNS()).orElse(null));
  }
  
  public ExternalDNSNested<A> editOrNewExternalDNS() {
    return withNewExternalDNSLike(java.util.Optional.ofNullable(buildExternalDNS()).orElse(new ExternalDNSConfigBuilder().build()));
  }
  
  public ExternalDNSNested<A> editOrNewExternalDNSLike(ExternalDNSConfig item) {
    return withNewExternalDNSLike(java.util.Optional.ofNullable(buildExternalDNS()).orElse(item));
  }
  
  public FailedProvisionConfig buildFailedProvisionConfig() {
    return this.failedProvisionConfig != null ? this.failedProvisionConfig.build() : null;
  }
  
  public A withFailedProvisionConfig(FailedProvisionConfig failedProvisionConfig) {
    this._visitables.remove(this.failedProvisionConfig);
    if (failedProvisionConfig != null) {
        this.failedProvisionConfig = new FailedProvisionConfigBuilder(failedProvisionConfig);
        this._visitables.get("failedProvisionConfig").add(this.failedProvisionConfig);
    } else {
        this.failedProvisionConfig = null;
        this._visitables.get("failedProvisionConfig").remove(this.failedProvisionConfig);
    }
    return (A) this;
  }
  
  public boolean hasFailedProvisionConfig() {
    return this.failedProvisionConfig != null;
  }
  
  public A withNewFailedProvisionConfig(Boolean skipGatherLogs) {
    return (A)withFailedProvisionConfig(new FailedProvisionConfig(skipGatherLogs));
  }
  
  public FailedProvisionConfigNested<A> withNewFailedProvisionConfig() {
    return new FailedProvisionConfigNested(null);
  }
  
  public FailedProvisionConfigNested<A> withNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return new FailedProvisionConfigNested(item);
  }
  
  public FailedProvisionConfigNested<A> editFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(java.util.Optional.ofNullable(buildFailedProvisionConfig()).orElse(null));
  }
  
  public FailedProvisionConfigNested<A> editOrNewFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(java.util.Optional.ofNullable(buildFailedProvisionConfig()).orElse(new FailedProvisionConfigBuilder().build()));
  }
  
  public FailedProvisionConfigNested<A> editOrNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return withNewFailedProvisionConfigLike(java.util.Optional.ofNullable(buildFailedProvisionConfig()).orElse(item));
  }
  
  public LocalObjectReference buildGlobalPullSecret() {
    return this.globalPullSecret != null ? this.globalPullSecret.build() : null;
  }
  
  public A withGlobalPullSecret(LocalObjectReference globalPullSecret) {
    this._visitables.remove(this.globalPullSecret);
    if (globalPullSecret != null) {
        this.globalPullSecret = new LocalObjectReferenceBuilder(globalPullSecret);
        this._visitables.get("globalPullSecret").add(this.globalPullSecret);
    } else {
        this.globalPullSecret = null;
        this._visitables.get("globalPullSecret").remove(this.globalPullSecret);
    }
    return (A) this;
  }
  
  public boolean hasGlobalPullSecret() {
    return this.globalPullSecret != null;
  }
  
  public A withNewGlobalPullSecret(String name) {
    return (A)withGlobalPullSecret(new LocalObjectReference(name));
  }
  
  public GlobalPullSecretNested<A> withNewGlobalPullSecret() {
    return new GlobalPullSecretNested(null);
  }
  
  public GlobalPullSecretNested<A> withNewGlobalPullSecretLike(LocalObjectReference item) {
    return new GlobalPullSecretNested(item);
  }
  
  public GlobalPullSecretNested<A> editGlobalPullSecret() {
    return withNewGlobalPullSecretLike(java.util.Optional.ofNullable(buildGlobalPullSecret()).orElse(null));
  }
  
  public GlobalPullSecretNested<A> editOrNewGlobalPullSecret() {
    return withNewGlobalPullSecretLike(java.util.Optional.ofNullable(buildGlobalPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public GlobalPullSecretNested<A> editOrNewGlobalPullSecretLike(LocalObjectReference item) {
    return withNewGlobalPullSecretLike(java.util.Optional.ofNullable(buildGlobalPullSecret()).orElse(item));
  }
  
  public Boolean getMaintenanceMode() {
    return this.maintenanceMode;
  }
  
  public A withMaintenanceMode(Boolean maintenanceMode) {
    this.maintenanceMode = maintenanceMode;
    return (A) this;
  }
  
  public boolean hasMaintenanceMode() {
    return this.maintenanceMode != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HiveConfigSpecFluent that = (HiveConfigSpecFluent) o;
    if (!java.util.Objects.equals(additionalCertificateAuthorities, that.additionalCertificateAuthorities)) return false;
    if (!java.util.Objects.equals(backup, that.backup)) return false;
    if (!java.util.Objects.equals(externalDNS, that.externalDNS)) return false;
    if (!java.util.Objects.equals(failedProvisionConfig, that.failedProvisionConfig)) return false;
    if (!java.util.Objects.equals(globalPullSecret, that.globalPullSecret)) return false;
    if (!java.util.Objects.equals(maintenanceMode, that.maintenanceMode)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalCertificateAuthorities,  backup,  externalDNS,  failedProvisionConfig,  globalPullSecret,  maintenanceMode,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalCertificateAuthorities != null && !additionalCertificateAuthorities.isEmpty()) { sb.append("additionalCertificateAuthorities:"); sb.append(additionalCertificateAuthorities + ","); }
    if (backup != null) { sb.append("backup:"); sb.append(backup + ","); }
    if (externalDNS != null) { sb.append("externalDNS:"); sb.append(externalDNS + ","); }
    if (failedProvisionConfig != null) { sb.append("failedProvisionConfig:"); sb.append(failedProvisionConfig + ","); }
    if (globalPullSecret != null) { sb.append("globalPullSecret:"); sb.append(globalPullSecret + ","); }
    if (maintenanceMode != null) { sb.append("maintenanceMode:"); sb.append(maintenanceMode); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withMaintenanceMode() {
    return withMaintenanceMode(true);
  }
  public class AdditionalCertificateAuthoritiesNested<N> extends LocalObjectReferenceFluent<AdditionalCertificateAuthoritiesNested<N>> implements Nested<N>{
    AdditionalCertificateAuthoritiesNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) HiveConfigSpecFluent.this.setToAdditionalCertificateAuthorities(index,builder.build());
    }
    
    public N endAdditionalCertificateAuthority() {
      return and();
    }
    
  
  }
  public class BackupNested<N> extends BackupConfigFluent<BackupNested<N>> implements Nested<N>{
    BackupNested(BackupConfig item) {
      this.builder = new BackupConfigBuilder(this, item);
    }
    BackupConfigBuilder builder;
    
    public N and() {
      return (N) HiveConfigSpecFluent.this.withBackup(builder.build());
    }
    
    public N endBackup() {
      return and();
    }
    
  
  }
  public class ExternalDNSNested<N> extends ExternalDNSConfigFluent<ExternalDNSNested<N>> implements Nested<N>{
    ExternalDNSNested(ExternalDNSConfig item) {
      this.builder = new ExternalDNSConfigBuilder(this, item);
    }
    ExternalDNSConfigBuilder builder;
    
    public N and() {
      return (N) HiveConfigSpecFluent.this.withExternalDNS(builder.build());
    }
    
    public N endExternalDNS() {
      return and();
    }
    
  
  }
  public class FailedProvisionConfigNested<N> extends FailedProvisionConfigFluent<FailedProvisionConfigNested<N>> implements Nested<N>{
    FailedProvisionConfigNested(FailedProvisionConfig item) {
      this.builder = new FailedProvisionConfigBuilder(this, item);
    }
    FailedProvisionConfigBuilder builder;
    
    public N and() {
      return (N) HiveConfigSpecFluent.this.withFailedProvisionConfig(builder.build());
    }
    
    public N endFailedProvisionConfig() {
      return and();
    }
    
  
  }
  public class GlobalPullSecretNested<N> extends LocalObjectReferenceFluent<GlobalPullSecretNested<N>> implements Nested<N>{
    GlobalPullSecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) HiveConfigSpecFluent.this.withGlobalPullSecret(builder.build());
    }
    
    public N endGlobalPullSecret() {
      return and();
    }
    
  
  }

}