package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExternalDNSConfigFluent<A extends ExternalDNSConfigFluent<A>> extends BaseFluent<A>{
  public ExternalDNSConfigFluent() {
  }
  
  public ExternalDNSConfigFluent(ExternalDNSConfig instance) {
    this.copyInstance(instance);
  }
  private ExternalDNSAWSConfigBuilder aws;
  private ExternalDNSGCPConfigBuilder gcp;
  
  protected void copyInstance(ExternalDNSConfig instance) {
    instance = (instance != null ? instance : new ExternalDNSConfig());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withGcp(instance.getGcp());
          this.withAws(instance.getAws());
          this.withGcp(instance.getGcp());
        }
  }
  
  public ExternalDNSAWSConfig buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(ExternalDNSAWSConfig aws) {
    this._visitables.remove(this.aws);
    if (aws != null) {
        this.aws = new ExternalDNSAWSConfigBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(ExternalDNSAWSConfig item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new ExternalDNSAWSConfigBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(ExternalDNSAWSConfig item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public ExternalDNSGCPConfig buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(ExternalDNSGCPConfig gcp) {
    this._visitables.remove(this.gcp);
    if (gcp != null) {
        this.gcp = new ExternalDNSGCPConfigBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(ExternalDNSGCPConfig item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new ExternalDNSGCPConfigBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(ExternalDNSGCPConfig item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalDNSConfigFluent that = (ExternalDNSConfigFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  gcp,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends ExternalDNSAWSConfigFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(ExternalDNSAWSConfig item) {
      this.builder = new ExternalDNSAWSConfigBuilder(this, item);
    }
    ExternalDNSAWSConfigBuilder builder;
    
    public N and() {
      return (N) ExternalDNSConfigFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends ExternalDNSGCPConfigFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(ExternalDNSGCPConfig item) {
      this.builder = new ExternalDNSGCPConfigBuilder(this, item);
    }
    ExternalDNSGCPConfigBuilder builder;
    
    public N and() {
      return (N) ExternalDNSConfigFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }

}